/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.cli;

import java.util.prefs.Preferences;
import nsusbloader.NSLMain;
import nsusbloader.cli.ExperimentalCli;
import nsusbloader.cli.GoldLeafCli;
import nsusbloader.cli.IncorrectSetupException;
import nsusbloader.cli.MergeCli;
import nsusbloader.cli.RcmCli;
import nsusbloader.cli.SplitCli;
import nsusbloader.cli.TinfoilNetCli;
import nsusbloader.cli.TinfoilUsbCli;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandLineInterface {
    public CommandLineInterface(String[] args) {
        if (this.noRealKeys(args)) {
            System.out.println("Try 'ns-usbloader --help' for more information.");
            return;
        }
        Options cliOptions = this.createCliOptions();
        DefaultParser cliParser = new DefaultParser();
        try {
            CommandLine cli = cliParser.parse(cliOptions, args);
            if (cli.hasOption('v') || cli.hasOption("version")) {
                this.handleVersion();
                return;
            }
            if (cli.hasOption('h') || cli.hasOption("help")) {
                this.handleHelp(cliOptions);
                return;
            }
            if (cli.hasOption('r') || cli.hasOption("rcm")) {
                String payloadArgument = cli.getOptionValue("rcm");
                new RcmCli(payloadArgument);
                return;
            }
            if (cli.hasOption("c") || cli.hasOption("clean")) {
                this.handleSettingClean();
                return;
            }
            if (cli.hasOption("n") || cli.hasOption("tfn")) {
                String[] arguments = cli.getOptionValues("tfn");
                new TinfoilNetCli(arguments);
                return;
            }
            if (cli.hasOption("t") || cli.hasOption("tinfoil")) {
                String[] arguments = cli.getOptionValues("tinfoil");
                new TinfoilUsbCli(arguments);
                return;
            }
            if (cli.hasOption("g") || cli.hasOption("goldleaf")) {
                String[] arguments = cli.getOptionValues("goldleaf");
                new GoldLeafCli(arguments);
                return;
            }
            if (cli.hasOption("experimental")) {
                String[] arguments = cli.getOptionValues("experimental");
                new ExperimentalCli(arguments);
                return;
            }
            if (cli.hasOption("s") || cli.hasOption("split")) {
                String[] arguments = cli.getOptionValues("split");
                new SplitCli(arguments);
                return;
            }
            if (cli.hasOption("m") || cli.hasOption("merge")) {
                String[] arguments = cli.getOptionValues("merge");
                new MergeCli(arguments);
                return;
            }
        }
        catch (ParseException pe) {
            System.out.println(pe.getLocalizedMessage() + "\nTry 'ns-usbloader --help' for more information.");
        }
        catch (IncorrectSetupException iee) {
            System.out.println(iee.getLocalizedMessage());
        }
        catch (InterruptedException iee) {
        }
        catch (Exception e) {
            System.out.println("CLI error");
            e.printStackTrace();
        }
    }

    private boolean noRealKeys(String[] args) {
        return args.length > 0 && !args[0].startsWith("-");
    }

    private Options createCliOptions() {
        Options options = new Options();
        Option rcmOption = Option.builder("r").longOpt("rcm").desc("Send payload").hasArg(true).argName("[PATH/]payload.bin").numberOfArgs(1).build();
        Option cleanSettingsOption = Option.builder("c").longOpt("clean").desc("Remove/reset settings and exit").hasArg(false).build();
        Option versionOption = Option.builder("v").longOpt("version").desc("Show application version").hasArg(false).build();
        Option helpOption = Option.builder("h").longOpt("help").desc("Show this help").hasArg(false).build();
        Option tinfoilNetOption = Option.builder("n").longOpt("tfn").desc("Install via Awoo Network mode. Check '-n help' for information.").hasArgs().argName("...").build();
        Option tinfoilOption = Option.builder("t").longOpt("tinfoil").desc("Install via Awoo USB mode.").hasArgs().argName("FILE...").build();
        Option glOption = Option.builder("g").longOpt("goldleaf").desc("Install via GoldLeaf mode. Check '-g help' for information.").hasArgs().argName("...").build();
        Option experimentalOption = Option.builder().longOpt("experimental").desc("Enable testing and experimental functions").hasArgs().argName("y|n").build();
        Option splitOption = Option.builder("s").longOpt("split").desc("Split files. Check '-s help' for information.").hasArgs().argName("...").build();
        Option mergeOption = Option.builder("m").longOpt("merge").desc("Merge files. Check '-m help' for information.").hasArgs().argName("...").build();
        OptionGroup group = new OptionGroup();
        group.addOption(rcmOption);
        group.addOption(tinfoilNetOption);
        group.addOption(cleanSettingsOption);
        group.addOption(versionOption);
        group.addOption(helpOption);
        group.addOption(tinfoilOption);
        group.addOption(glOption);
        group.addOption(experimentalOption);
        group.addOption(splitOption);
        group.addOption(mergeOption);
        options.addOptionGroup(group);
        return options;
    }

    private void handleVersion() {
        System.out.println("NS-USBloader " + NSLMain.appVersion);
    }

    private void handleSettingClean() throws Exception {
        if (Preferences.userRoot().nodeExists("NS-USBloader")) {
            Preferences.userRoot().node("NS-USBloader").removeNode();
            System.out.println("Settings removed");
        } else {
            System.out.println("There are no settings in system to remove");
        }
    }

    private void handleHelp(Options cliOptions) {
        new HelpFormatter().printHelp(120, "NS-USBloader.jar [OPTION]... [FILE]...", "options:", cliOptions, "\n");
    }
}

