/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.loader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.fs.other.System2.ini1.KIP1Provider;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.patches.BinToAsmPrinter;
import nsusbloader.Utilities.patches.SimplyFind;
import nsusbloader.Utilities.patches.loader.LoaderIniMaker;

public class LoaderPatch {
    private static final byte[] HEADER = "PATCH".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FOOTER = "EOF".getBytes(StandardCharsets.US_ASCII);
    private static final String ATMOSPHERE_NEW_PATTERN = "01C0BE121F00016B";
    private final String saveToLocation;
    private final ILogPrinter logPrinter;
    private String patchName;
    private byte[] _textSection;
    private int offset;

    LoaderPatch(KIP1Provider loaderProvider, String saveToLocation, ILogPrinter logPrinter) throws Exception {
        this.saveToLocation = saveToLocation;
        this.logPrinter = logPrinter;
        this.getPatchName(loaderProvider);
        this.getTextSection(loaderProvider);
        this.findOffset();
        this.mkDirs();
        this.writeFile();
        new LoaderIniMaker(logPrinter, saveToLocation, this.offset, this.patchName);
    }

    private void getPatchName(KIP1Provider kip1Provider) throws Exception {
        int kip1EncryptedSize = (int)kip1Provider.getSize();
        byte[] kip1EncryptedRaw = new byte[kip1EncryptedSize];
        try (BufferedInputStream kip1ProviderStream = kip1Provider.getStreamProducer().produce();){
            if (kip1EncryptedSize != kip1ProviderStream.read(kip1EncryptedRaw)) {
                throw new Exception("Unencrypted FS KIP1 read failure");
            }
        }
        byte[] sha256ofKip1 = MessageDigest.getInstance("SHA-256").digest(kip1EncryptedRaw);
        this.patchName = Converter.byteArrToHexStringAsLE(sha256ofKip1, true) + ".ips";
    }

    private void getTextSection(KIP1Provider kip1Provider) throws Exception {
        this._textSection = kip1Provider.getAsDecompressed().getTextRaw();
    }

    private void findOffset() throws Exception {
        SimplyFind simplyFind = new SimplyFind(ATMOSPHERE_NEW_PATTERN, this._textSection);
        if (simplyFind.getResults().size() == 0) {
            throw new Exception("Offset not found");
        }
        this.offset = simplyFind.getResults().get(0);
        if (this.offset <= 0) {
            throw new Exception("Found offset is incorrect");
        }
        for (int i = 0; i < simplyFind.getResults().size(); ++i) {
            int offsetInternal = simplyFind.getResults().get(i) + 4;
            this.logPrinter.print("Only first (#1) found record will be patched!", EMsgType.INFO);
            this.logPrinter.print("Found #" + (i + 1) + "\n" + BinToAsmPrinter.printSimplified(Converter.getLEint(this._textSection, offsetInternal), offsetInternal) + BinToAsmPrinter.printSimplified(Converter.getLEint(this._textSection, offsetInternal + 4), offsetInternal + 4) + BinToAsmPrinter.printSimplified(Converter.getLEint(this._textSection, offsetInternal + 8), offsetInternal + 8) + BinToAsmPrinter.printSimplified(Converter.getLEint(this._textSection, offsetInternal + 12), offsetInternal + 12), EMsgType.NULL);
        }
    }

    private void mkDirs() {
        File parentFolder = new File(this.saveToLocation + File.separator + "atmosphere" + File.separator + "kip_patches" + File.separator + "loader_patches");
        parentFolder.mkdirs();
    }

    private void writeFile() throws Exception {
        String patchFileLocation = this.saveToLocation + File.separator + "atmosphere" + File.separator + "kip_patches" + File.separator + "loader_patches" + File.separator + this.patchName;
        ByteBuffer handyFsPatch = ByteBuffer.allocate(256).order(ByteOrder.LITTLE_ENDIAN);
        handyFsPatch.put(HEADER);
        handyFsPatch.put(this.getPatch1(this.offset));
        handyFsPatch.put(FOOTER);
        byte[] fsPatch = new byte[handyFsPatch.position()];
        ((Buffer)handyFsPatch).rewind();
        handyFsPatch.get(fsPatch);
        try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(Paths.get(patchFileLocation, new String[0]), new OpenOption[0]));){
            stream.write(fsPatch);
        }
        this.logPrinter.print("Patch created at " + patchFileLocation, EMsgType.PASS);
    }

    private byte[] getPatch1(int offset) throws Exception {
        int requiredInstructionOffsetInternal = offset + 6;
        int requiredInstructionOffsetReal = requiredInstructionOffsetInternal + 256;
        byte[] patch = new byte[]{0, 1, 0};
        int instructionPatched = Converter.getLEint(this._textSection, offset + 4) & 0xFF00FFFF;
        this.logPrinter.print("Patch will be applied", EMsgType.PASS);
        this.logPrinter.print(BinToAsmPrinter.printSimplified(instructionPatched, offset + 4), EMsgType.NULL);
        ByteBuffer prePatch = ByteBuffer.allocate(7).order(ByteOrder.BIG_ENDIAN).putInt(requiredInstructionOffsetReal).put(patch);
        return Arrays.copyOfRange(prePatch.array(), 1, 7);
    }
}

