/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.nxdumptool;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class NxdtNspFile {
    private final String name;
    private final int headerSize;
    private final long fullSize;
    private long nspRemainingSize;
    private final File file;

    NxdtNspFile(String name, int headerSize, long fullSize, File file) throws Exception {
        this.name = name;
        this.headerSize = headerSize;
        this.fullSize = fullSize;
        this.file = file;
        this.nspRemainingSize = fullSize - (long)headerSize;
        this.removeIfExists();
        this.createHeaderFiller();
    }

    private void removeIfExists() throws Exception {
        if (!this.file.exists()) {
            return;
        }
        if (this.file.delete()) {
            return;
        }
        throw new Exception("Unable to delete leftovers of the NSP file: " + this.name);
    }

    private void createHeaderFiller() throws Exception {
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");){
            raf.setLength(this.headerSize);
        }
        catch (IOException e) {
            throw new Exception("Unable to reserve space for NSP file's header: " + e.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public long getFullSize() {
        return this.fullSize;
    }

    public File getFile() {
        return this.file;
    }

    public long getNspRemainingSize() {
        return this.nspRemainingSize;
    }

    public void setNspRemainingSize(long nspRemainingSize) {
        this.nspRemainingSize = nspRemainingSize;
    }
}

