/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.WindowsDrivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javafx.concurrent.Task;

public class DownloadDriversTask
extends Task<String> {
    public static final long DRIVERS_FILE_SIZE = 3857375L;
    private static final String driverFileLocationURL = "https://github.com/developersu/NS-Drivers/releases/download/v1.0/Drivers_set.exe";
    private static File driversInstallerFile;

    @Override
    protected String call() {
        if (this.isDriversDownloaded() || this.downloadDrivers()) {
            return driversInstallerFile.getAbsolutePath();
        }
        return null;
    }

    private boolean isDriversDownloaded() {
        return driversInstallerFile != null && driversInstallerFile.length() == 3857375L;
    }

    private boolean downloadDrivers() {
        try {
            int bytesRead;
            File tmpDirectory = File.createTempFile("nsul", null);
            if (!tmpDirectory.delete()) {
                return false;
            }
            if (!tmpDirectory.mkdirs()) {
                return false;
            }
            tmpDirectory.deleteOnExit();
            URL url = new URL(driverFileLocationURL);
            BufferedInputStream bis = new BufferedInputStream(url.openStream());
            driversInstallerFile = new File(tmpDirectory, "drivers.exe");
            FileOutputStream fos = new FileOutputStream(driversInstallerFile);
            byte[] dataBuffer = new byte[1024];
            double totalRead = 0.0;
            while ((bytesRead = bis.read(dataBuffer, 0, 1024)) != -1) {
                fos.write(dataBuffer, 0, bytesRead);
                this.updateProgress(totalRead += (double)bytesRead, 3857375.0);
                if (!this.isCancelled()) continue;
                bis.close();
                fos.close();
                this.updateProgress(0L, 0L);
                return false;
            }
            bis.close();
            fos.close();
            return true;
        }
        catch (IOException | SecurityException e) {
            this.updateMessage("Error: " + e.toString().replaceAll(":.*$", ""));
            e.printStackTrace();
            return false;
        }
    }
}

