/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.ModelControllers.Log;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.RcmSmash;
import nsusbloader.com.usb.UsbConnect;
import nsusbloader.com.usb.UsbErrorCodes;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;

public class Rcm
implements Runnable {
    private final ILogPrinter logPrinter = Log.getPrinter(EModule.RCM);
    private final String filePath;
    private DeviceHandle handler;
    private byte[] fullPayload;
    private static final byte[] initSeq = new byte[]{-104, 2, 3};
    private static final byte[] mezzo = new byte[]{92, 0, -97, -27, 92, 16, -97, -27, 92, 32, -97, -27, 1, 32, 66, -32, 14, 0, 0, -21, 72, 0, -97, -27, 16, -1, 47, -31, 0, 0, -96, -31, 72, 0, -97, -27, 72, 16, -97, -27, 1, 41, -96, -29, 7, 0, 0, -21, 56, 0, -97, -27, 1, 25, -96, -29, 1, 0, -128, -32, 52, 16, -97, -27, 3, 40, -96, -29, 1, 0, 0, -21, 32, 0, -97, -27, 16, -1, 47, -31, 4, 48, -111, -28, 4, 48, -128, -28, 4, 32, 82, -30, -5, -1, -1, 26, 30, -1, 47, -31, 0, -16, 0, 64, 32, 0, 1, 64, 124, 0, 1, 64, 0, 0, 1, 64, 64, 14, 1, 64, 0, 112, 1, 64};
    private static final byte[] sprayPttrn = new byte[]{0, 0, 1, 64};

    public Rcm(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public void run() {
        this.print("Selected: " + this.filePath, EMsgType.INFO);
        this.print("=============== RCM ===============", EMsgType.INFO);
        String realOsName = System.getProperty("os.name").toLowerCase().replace(" ", "");
        ECurrentOS ecurrentOS = realOsName.equals("macos") || realOsName.equals("macosx") || realOsName.equals("freebsd") ? ECurrentOS.mac : (realOsName.contains("windows") ? ECurrentOS.win : (realOsName.equals("linux") ? ECurrentOS.lin : ECurrentOS.unsupported));
        this.print("Found your OS: " + System.getProperty("os.name"), EMsgType.PASS);
        if (!ecurrentOS.equals((Object)ECurrentOS.mac) && !RcmSmash.isSupported()) {
            this.print("Unfortunately your platform '" + System.getProperty("os.name") + "' of '" + System.getProperty("os.arch") + "' is not supported :(\n         But you could file a bug with request.\n\n         Nothing has been sent to NS. Execution stopped.", EMsgType.FAIL);
            this.logPrinter.close();
            return;
        }
        if (this.preparePayload()) {
            this.logPrinter.close();
            return;
        }
        UsbConnect usbConnect = UsbConnect.connectRcmMode(this.logPrinter);
        if (!usbConnect.isConnected()) {
            this.logPrinter.close();
            return;
        }
        this.handler = usbConnect.getNsHandler();
        if (this.readUsbDeviceID()) {
            usbConnect.close();
            this.logPrinter.close();
            return;
        }
        for (int i = 0; i < this.fullPayload.length / 4096; ++i) {
            if (!this.writeUsb(Arrays.copyOfRange(this.fullPayload, i * 4096, (i + 1) * 4096))) continue;
            this.print("Failed to sent payload [" + i + "]\n\n         Execution stopped.", EMsgType.FAIL);
            usbConnect.close();
            this.logPrinter.close();
            return;
        }
        this.print("Information sent to NS.", EMsgType.PASS);
        if (ecurrentOS.equals((Object)ECurrentOS.mac)) {
            if (this.smashMacOS()) {
                usbConnect.close();
                this.logPrinter.close();
                return;
            }
        } else {
            int retval;
            if (ecurrentOS.equals((Object)ECurrentOS.lin)) {
                retval = RcmSmash.smashLinux(usbConnect.getNsBus(), usbConnect.getNsAddress());
            } else if (ecurrentOS.equals((Object)ECurrentOS.win)) {
                retval = RcmSmash.smashWindows();
            } else {
                this.print("Failed to smash the stack since your OS is not supported. Please report this issue.\n\n         Execution stopped and failed. And it's strange.", EMsgType.FAIL);
                usbConnect.close();
                this.logPrinter.close();
                return;
            }
            if (retval != 0) {
                this.print("Failed to smash the stack (" + retval + ")\n\n         Execution stopped and failed.", EMsgType.FAIL);
                usbConnect.close();
                this.logPrinter.close();
                return;
            }
        }
        this.print(".:: Payload complete ::.", EMsgType.PASS);
        usbConnect.close();
        this.logPrinter.updateOneLinerStatus(true);
        this.logPrinter.close();
    }

    private void print(String message, EMsgType type) {
        try {
            this.logPrinter.print(message, type);
        }
        catch (InterruptedException intr) {
            intr.printStackTrace();
        }
    }

    private boolean preparePayload() {
        File pldrFile = new File(this.filePath);
        if (pldrFile.length() > 126296L || pldrFile.length() < 16384L) {
            this.print("File size of this payload looks wired. It's " + pldrFile.length() + " bytes.\n         1. Double-check that you're using the right payload.\n         2. Please report this issue in case you're sure that you're doing everything right.\n\n         Nothing has been sent to NS. Execution stopped.", EMsgType.FAIL);
            return true;
        }
        int pldFileSize = (int)pldrFile.length();
        int totalSize = 4328 + pldFileSize + 8640;
        if ((totalSize += 4096 - totalSize % 4096) / 4096 % 2 == 0) {
            totalSize += 4096;
        }
        if (totalSize > 197272) {
            this.print("File size of the payload is too big. Comparing to maximum size, it's greater to " + (totalSize - 197272) + " bytes!\n         1. Double-check that you're using the right payload.\n         2. Please report this issue in case you're sure that you're doing everything right.\n\n         Nothing has been sent to NS. Execution stopped.", EMsgType.FAIL);
            return true;
        }
        this.fullPayload = new byte[totalSize];
        byte[] dataPldFile = new byte[pldFileSize];
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(pldrFile));
            int readSize = bis.read(dataPldFile);
            if (readSize != pldFileSize) {
                this.print("Failed to retrieve data from payload file.\n         Got only " + readSize + " bytes while " + pldFileSize + " expected.\n\n         Nothing has been sent to NS. Execution stopped.", EMsgType.FAIL);
                bis.close();
                return true;
            }
            bis.close();
        }
        catch (Exception e) {
            this.print("Failed to retrieve data from payload file: " + e.getMessage() + "\n\n         Nothing has been sent to NS. Execution stopped.", EMsgType.FAIL);
            return true;
        }
        System.arraycopy(initSeq, 0, this.fullPayload, 0, 3);
        System.arraycopy(mezzo, 0, this.fullPayload, 680, 124);
        System.arraycopy(dataPldFile, 0, this.fullPayload, 4328, 16384);
        for (int i = 0; i < 2160; ++i) {
            System.arraycopy(sprayPttrn, 0, this.fullPayload, 20712 + i * 4, 4);
        }
        System.arraycopy(dataPldFile, 16384, this.fullPayload, 29352, pldFileSize - 16384);
        return false;
    }

    private boolean readUsbDeviceID() {
        IntBuffer readBufTransferred;
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(16);
        int result = LibUsb.bulkTransfer(this.handler, (byte)-127, readBuffer, readBufTransferred = IntBuffer.allocate(1), 1000L);
        if (result != 0) {
            this.print("Unable to get device ID\n\n         Nothing has been sent to NS. Execution stopped.", EMsgType.FAIL);
            return true;
        }
        int trans = readBufTransferred.get();
        byte[] receivedBytes = new byte[trans];
        readBuffer.get(receivedBytes);
        StringBuilder idStrBld = new StringBuilder("Found device with ID: ");
        for (byte b : receivedBytes) {
            idStrBld.append(String.format("%02x ", b));
        }
        this.print(idStrBld.toString(), EMsgType.PASS);
        return false;
    }

    private boolean writeUsb(byte[] message) {
        ByteBuffer writeBuffer = ByteBuffer.allocateDirect(4096);
        writeBuffer.put(message);
        IntBuffer writeBufTransferred = IntBuffer.allocate(1);
        int result = LibUsb.bulkTransfer(this.handler, (byte)1, writeBuffer, writeBufTransferred, 5050L);
        if (result == 0) {
            if (writeBufTransferred.get() == 4096) {
                return false;
            }
            this.print("RCM Data transfer issue [write]\n         Requested: " + message.length + "\n         Transferred: " + writeBufTransferred.get() + "\n\n         Execution stopped.", EMsgType.FAIL);
            return true;
        }
        this.print("RCM Data transfer issue [write]\n         Returned: " + UsbErrorCodes.getErrCode(result) + "\n\n         Execution stopped.", EMsgType.FAIL);
        return true;
    }

    boolean smashMacOS() {
        ByteBuffer writeBuffer = ByteBuffer.allocateDirect(28672);
        LibUsb.controlTransfer(this.handler, (byte)-126, (byte)0, (short)0, (short)0, writeBuffer, 1000L);
        return false;
    }

    private static enum ECurrentOS {
        win,
        lin,
        mac,
        unsupported;

    }
}

