/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader;

import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import nsusbloader.AppPreferences;
import nsusbloader.Controllers.NSLMainController;
import nsusbloader.MediatorControl;
import nsusbloader.ServiceWindow;
import nsusbloader.cli.CommandLineInterface;

public class NSLMain
extends Application {
    public static String appVersion;
    public static boolean isCli;

    @Override
    public void start(Stage primaryStage) throws Exception {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/NSLMain.fxml"));
        Locale userLocale = AppPreferences.getInstance().getLocale();
        ResourceBundle rb = ResourceBundle.getBundle("locale", userLocale);
        loader.setResources(rb);
        Parent root = (Parent)loader.load();
        primaryStage.getIcons().addAll((Image[])new Image[]{new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/res/app_icon32x32.png"))), new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/res/app_icon48x48.png"))), new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/res/app_icon64x64.png"))), new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/res/app_icon128x128.png")))});
        primaryStage.setTitle("NS-USBloader " + appVersion);
        primaryStage.setMinWidth(650.0);
        primaryStage.setMinHeight(450.0);
        Scene mainScene = new Scene(root, AppPreferences.getInstance().getSceneWidth(), AppPreferences.getInstance().getSceneHeight());
        mainScene.getStylesheets().add(AppPreferences.getInstance().getTheme());
        root.setStyle(AppPreferences.getInstance().getFontStyle());
        primaryStage.setScene(mainScene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(e -> {
            if (MediatorControl.INSTANCE.getTransferActive() && !ServiceWindow.getConfirmationWindow(rb.getString("windowTitleConfirmExit"), rb.getString("windowBodyConfirmExit"))) {
                e.consume();
            }
        });
        NSLMainController controller = (NSLMainController)loader.getController();
        MediatorControl.INSTANCE.setHostServices(this.getHostServices());
        primaryStage.setOnHidden(e -> {
            AppPreferences.getInstance().setSceneHeight(mainScene.getHeight());
            AppPreferences.getInstance().setSceneWidth(mainScene.getWidth());
            controller.exit();
        });
    }

    public static void main(String[] args) {
        appVersion = ResourceBundle.getBundle("app").getString("_version");
        if (args.length == 0) {
            NSLMain.launch(args);
        } else {
            isCli = true;
            new CommandLineInterface(args);
        }
    }
}

