/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import nsusbloader.AppPreferences;
import nsusbloader.Controllers.ISubscriber;
import nsusbloader.Controllers.Payload;
import nsusbloader.FilesHelper;
import nsusbloader.MediatorControl;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.ServiceWindow;
import nsusbloader.Utilities.patches.es.EsPatchMaker;
import nsusbloader.Utilities.patches.fs.FsPatchMaker;
import nsusbloader.Utilities.patches.loader.LoaderPatchMaker;

public class PatchesController
implements Initializable,
ISubscriber {
    @FXML
    private VBox patchesToolPane;
    @FXML
    private Button makeEsBtn;
    @FXML
    private Button makeFsBtn;
    @FXML
    private Button makeLoaderBtn;
    @FXML
    private Label shortNameFirmwareLbl;
    @FXML
    private Label locationFirmwareLbl;
    @FXML
    private Label saveToLbl;
    @FXML
    private Label shortNameKeysLbl;
    @FXML
    private Label locationKeysLbl;
    @FXML
    private Label statusLbl;
    @FXML
    private Label locationAtmosphereLbl;
    @FXML
    private Label shortNameAtmoLbl;
    private Thread workThread;
    private String previouslyOpenedPath;
    private ResourceBundle resourceBundle;
    private Region convertRegionEs;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.previouslyOpenedPath = System.getProperty("user.home");
        String myRegexp = File.separator.equals("/") ? "^.+/" : "^.+\\\\";
        this.locationFirmwareLbl.textProperty().addListener((observableValue, currentText, updatedText) -> this.shortNameFirmwareLbl.setText(updatedText.replaceAll(myRegexp, "")));
        this.locationKeysLbl.textProperty().addListener((observableValue, currentText, updatedText) -> this.shortNameKeysLbl.setText(updatedText.replaceAll(myRegexp, "")));
        this.locationAtmosphereLbl.textProperty().addListener((observableValue, currentText, updatedText) -> this.shortNameAtmoLbl.setText(updatedText.replaceAll(myRegexp, "")));
        this.convertRegionEs = this.createCakeRegion();
        this.makeEsBtn.setGraphic(this.convertRegionEs);
        this.makeFsBtn.setGraphic(this.createCakeRegion());
        this.makeLoaderBtn.setGraphic(this.createCakeRegion());
        AppPreferences preferences = AppPreferences.getInstance();
        String keysLocation = preferences.getKeysLocation();
        File keysFile = new File(keysLocation);
        if (keysFile.exists() && keysFile.isFile()) {
            this.locationKeysLbl.setText(keysLocation);
        }
        this.saveToLbl.setText(preferences.getPatchesSaveToLocation());
        this.makeEsBtn.disableProperty().bind(Bindings.or(Bindings.isEmpty(this.locationFirmwareLbl.textProperty()), Bindings.isEmpty(this.locationKeysLbl.textProperty())));
        this.makeEsBtn.setOnAction(actionEvent -> this.makeEs());
        this.makeFsBtn.disableProperty().bind(Bindings.or(Bindings.isEmpty(this.locationFirmwareLbl.textProperty()), Bindings.isEmpty(this.locationKeysLbl.textProperty())));
        this.makeFsBtn.setOnAction(actionEvent -> this.makeFs());
        this.makeLoaderBtn.disableProperty().bind(Bindings.isEmpty(this.locationAtmosphereLbl.textProperty()));
        this.makeLoaderBtn.setOnAction(actionEvent -> this.makeLoader());
    }

    private Region createCakeRegion() {
        Region cakeRegion = new Region();
        cakeRegion.getStyleClass().add("regionCake");
        return cakeRegion;
    }

    @FXML
    private void handleDragOver(DragEvent event) {
        if (event.getDragboard().hasFiles()) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    @FXML
    private void handleDrop(DragEvent event) {
        List<File> filesDropped = event.getDragboard().getFiles();
        for (File file : filesDropped) {
            if (file.isDirectory()) {
                if (file.getName().toLowerCase().contains("atmosphe")) {
                    this.locationAtmosphereLbl.setText(file.getAbsolutePath());
                    continue;
                }
                this.locationFirmwareLbl.setText(file.getAbsolutePath());
                continue;
            }
            String fileName = file.getName().toLowerCase();
            if (fileName.endsWith(".dat") || fileName.endsWith(".keys") && !fileName.equals("dev.keys") && !fileName.equals("title.keys")) {
                this.locationKeysLbl.setText(file.getAbsolutePath());
                continue;
            }
            if (!fileName.equals("offsets.txt")) continue;
            this.setOffsets(file);
        }
        event.setDropCompleted(true);
        event.consume();
    }

    private void setOffsets(File fileWithOffsets) {
        AppPreferences preferences = AppPreferences.getInstance();
        int count = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(fileWithOffsets));){
            String fileLine;
            while ((fileLine = reader.readLine()) != null) {
                String[] pointer;
                String[] lineValues;
                if (fileLine.startsWith("#") || (lineValues = fileLine.trim().split("\\s+?=\\s+?", 2)).length != 2 || !(pointer = lineValues[0].split("_", 3))[0].equals("ES") && !pointer[0].equals("FS") || !pointer[1].matches("^([0-9A-Fa-f]{2})$") || !pointer[2].matches("^([0-9A-Fa-f]{2})$") || !lineValues[1].matches("^(([0-9A-Fa-f]{2})|\\.)+?$")) continue;
                preferences.setPatchPattern(lineValues[0], lineValues[1]);
                System.out.println(pointer[0] + "_" + pointer[1] + "_" + pointer[2] + " = " + lineValues[1]);
                this.statusLbl.setText("OK " + ++count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void selectFirmware() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.resourceBundle.getString("tabPatches_Lbl_Firmware"));
        directoryChooser.setInitialDirectory(new File(FilesHelper.getRealFolder(this.previouslyOpenedPath)));
        File firmware = directoryChooser.showDialog(this.patchesToolPane.getScene().getWindow());
        if (firmware == null) {
            return;
        }
        this.locationFirmwareLbl.setText(firmware.getAbsolutePath());
        this.previouslyOpenedPath = firmware.getParent();
    }

    @FXML
    private void selectAtmosphereFolder() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.resourceBundle.getString("tabPatches_Lbl_Atmo"));
        directoryChooser.setInitialDirectory(new File(FilesHelper.getRealFolder(this.previouslyOpenedPath)));
        File firmware = directoryChooser.showDialog(this.patchesToolPane.getScene().getWindow());
        if (firmware == null) {
            return;
        }
        this.locationAtmosphereLbl.setText(firmware.getAbsolutePath());
        this.previouslyOpenedPath = firmware.getParent();
    }

    @FXML
    private void selectSaveTo() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.resourceBundle.getString("tabSplMrg_Btn_SelectFolder"));
        directoryChooser.setInitialDirectory(new File(FilesHelper.getRealFolder(this.previouslyOpenedPath)));
        File saveToDir = directoryChooser.showDialog(this.patchesToolPane.getScene().getWindow());
        if (saveToDir == null) {
            return;
        }
        this.saveToLbl.setText(saveToDir.getAbsolutePath());
    }

    @FXML
    private void selectProdKeys() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle.getString("tabPatches_Lbl_Keys"));
        fileChooser.setInitialDirectory(new File(FilesHelper.getRealFolder(this.previouslyOpenedPath)));
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("keys", "*.dat", "*.keys"));
        File keys = fileChooser.showOpenDialog(this.patchesToolPane.getScene().getWindow());
        if (keys == null || !keys.exists()) {
            return;
        }
        this.locationKeysLbl.setText(keys.getAbsolutePath());
        this.previouslyOpenedPath = keys.getParent();
    }

    private void makeEs() {
        if (this.locationFirmwareLbl.getText().isEmpty() || this.locationKeysLbl.getText().isEmpty()) {
            ServiceWindow.getErrorNotification(this.resourceBundle.getString("windowTitleError"), this.resourceBundle.getString("tabPatches_ServiceWindowMessageEsFs"));
            return;
        }
        if (this.workThread != null && this.workThread.isAlive()) {
            return;
        }
        if (MediatorControl.INSTANCE.getTransferActive()) {
            ServiceWindow.getErrorNotification(this.resourceBundle.getString("windowTitleError"), this.resourceBundle.getString("windowBodyPleaseStopOtherProcessFirst"));
            return;
        }
        EsPatchMaker esPatchMaker = new EsPatchMaker(this.locationFirmwareLbl.getText(), this.locationKeysLbl.getText(), this.saveToLbl.getText());
        this.workThread = new Thread(esPatchMaker);
        this.workThread.setDaemon(true);
        this.workThread.start();
    }

    private void makeFs() {
        if (this.locationFirmwareLbl.getText().isEmpty() || this.locationKeysLbl.getText().isEmpty()) {
            ServiceWindow.getErrorNotification(this.resourceBundle.getString("windowTitleError"), this.resourceBundle.getString("tabPatches_ServiceWindowMessageEsFs"));
            return;
        }
        if (this.workThread != null && this.workThread.isAlive()) {
            return;
        }
        if (MediatorControl.INSTANCE.getTransferActive()) {
            ServiceWindow.getErrorNotification(this.resourceBundle.getString("windowTitleError"), this.resourceBundle.getString("windowBodyPleaseStopOtherProcessFirst"));
            return;
        }
        FsPatchMaker fsPatchMaker = new FsPatchMaker(this.locationFirmwareLbl.getText(), this.locationKeysLbl.getText(), this.saveToLbl.getText());
        this.workThread = new Thread(fsPatchMaker);
        this.workThread.setDaemon(true);
        this.workThread.start();
    }

    private void makeLoader() {
        if (this.locationAtmosphereLbl.getText().isEmpty()) {
            ServiceWindow.getErrorNotification(this.resourceBundle.getString("windowTitleError"), this.resourceBundle.getString("tabPatches_ServiceWindowMessageLoader"));
            return;
        }
        if (this.workThread != null && this.workThread.isAlive()) {
            return;
        }
        if (MediatorControl.INSTANCE.getTransferActive()) {
            ServiceWindow.getErrorNotification(this.resourceBundle.getString("windowTitleError"), this.resourceBundle.getString("windowBodyPleaseStopOtherProcessFirst"));
            return;
        }
        LoaderPatchMaker loaderPatchMaker = new LoaderPatchMaker(this.locationAtmosphereLbl.getText(), this.saveToLbl.getText());
        this.workThread = new Thread(loaderPatchMaker);
        this.workThread.setDaemon(true);
        this.workThread.start();
    }

    private void interruptProcessOfPatchMaking() {
        if (this.workThread == null || !this.workThread.isAlive()) {
            return;
        }
        this.workThread.interrupt();
    }

    @Override
    public void notify(EModule type, boolean isActive, Payload payload) {
        if (!type.equals((Object)EModule.PATCHES)) {
            this.patchesToolPane.setDisable(isActive);
            return;
        }
        this.statusLbl.setText(payload.getMessage());
        this.convertRegionEs.getStyleClass().clear();
        this.makeFsBtn.setVisible(!isActive);
        this.makeLoaderBtn.setVisible(!isActive);
        if (isActive) {
            this.convertRegionEs.getStyleClass().add("regionStop");
            this.makeEsBtn.setOnAction(e -> this.interruptProcessOfPatchMaking());
            this.makeEsBtn.setText(this.resourceBundle.getString("btn_Stop"));
            this.makeEsBtn.getStyleClass().remove("buttonUp");
            this.makeEsBtn.getStyleClass().add("buttonStop");
            return;
        }
        this.convertRegionEs.getStyleClass().add("regionCake");
        this.makeEsBtn.setOnAction(actionEvent -> this.makeEs());
        this.makeEsBtn.setText(this.resourceBundle.getString("tabPatches_Btn_MakeEs"));
        this.makeEsBtn.getStyleClass().remove("buttonStop");
        this.makeEsBtn.getStyleClass().add("buttonUp");
    }

    void updatePreferencesOnExit() {
        AppPreferences.getInstance().setPatchesSaveToLocation(this.saveToLbl.getText());
        if (this.locationKeysLbl.getText().isEmpty()) {
            return;
        }
        AppPreferences.getInstance().setKeysLocation(this.locationKeysLbl.getText());
    }
}

