/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import nsusbloader.AppPreferences;
import nsusbloader.NSLDataTypes.EFileStatus;

public class NSLRowModel {
    private Locale userLocale = AppPreferences.getInstance().getLocale();
    private ResourceBundle rb = ResourceBundle.getBundle("locale", this.userLocale);
    private String status;
    private File nspFile;
    private String nspFileName;
    private long nspFileSize;
    private boolean markForUpload;

    NSLRowModel(File nspFile, boolean checkBoxValue) {
        this.nspFile = nspFile;
        this.markForUpload = checkBoxValue;
        this.nspFileName = nspFile.getName();
        if (nspFile.isFile()) {
            this.nspFileSize = nspFile.length();
        } else {
            File[] subFilesArr = nspFile.listFiles((file, name) -> name.matches("[0-9]{2}"));
            if (subFilesArr != null) {
                for (File subFile : subFilesArr) {
                    this.nspFileSize += subFile.length();
                }
            }
        }
        this.status = "";
    }

    public String getStatus() {
        return this.status;
    }

    public String getNspFileName() {
        return this.nspFileName;
    }

    public long getNspFileSize() {
        return this.nspFileSize;
    }

    public boolean isMarkForUpload() {
        return this.markForUpload;
    }

    public void setMarkForUpload(boolean value) {
        this.markForUpload = value;
    }

    public File getNspFile() {
        return this.nspFile;
    }

    public void setStatus(EFileStatus status) {
        switch (status) {
            case UPLOADED: {
                this.status = this.rb.getString("tab1_table_Lbl_Success");
                this.markForUpload = false;
                break;
            }
            case FAILED: {
                this.status = this.rb.getString("tab1_table_Lbl_Failed");
                break;
            }
            case INDETERMINATE: {
                this.status = "...";
                break;
            }
            case UNKNOWN: {
                this.status = this.rb.getString("tab1_table_Lbl_Unknown");
                break;
            }
            case INCORRECT_FILE_FAILED: {
                this.status = this.rb.getString("tab1_table_Lbl_BadFile");
                this.markForUpload = false;
            }
        }
    }
}

