/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.xtsaes;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.LongFunction;
import net.jcip.annotations.NotThreadSafe;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Pack;

@NotThreadSafe
class XTSTweak {
    private static final long FDBK = 135L;
    private static final long MSB = Long.MIN_VALUE;
    private static final int BLOCK_SIZE = 16;
    private final BlockCipher cipher;
    private final LongFunction<byte[]> tweakFunction;
    private final byte[] tweak;

    XTSTweak(BlockCipher cipher, LongFunction<byte[]> tweakFunction, byte[] tweak) {
        this.cipher = Objects.requireNonNull(cipher, "cipher");
        this.tweakFunction = Objects.requireNonNull(tweakFunction, "tweakFunction");
        this.tweak = Objects.requireNonNull(tweak, "tweak");
        if (cipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("bad block size: " + cipher.getBlockSize());
        }
    }

    XTSTweak(BlockCipher cipher, LongFunction<byte[]> tweakFunction) {
        this(cipher, tweakFunction, new byte[cipher.getBlockSize()]);
    }

    XTSTweak(LongFunction<byte[]> tweakFunction) {
        this(new AESEngine(), tweakFunction);
    }

    XTSTweak(boolean isDefault) {
        this(isDefault ? XTSTweak::defaultTweakFunction : XTSTweak::nintTweakFunction);
    }

    static byte[] defaultTweakFunction(long tweakValue) {
        byte[] bs = Pack.longToLittleEndian(tweakValue);
        bs = Arrays.copyOfRange(bs, 0, 16);
        return bs;
    }

    static byte[] nintTweakFunction(long tweakValue) {
        byte[] bs = new byte[16];
        byte[] twk = Pack.longToBigEndian(tweakValue);
        int j = 16 - twk.length;
        for (byte b : twk) {
            bs[j++] = b;
        }
        return bs;
    }

    XTSTweak init(KeyParameter key) throws IllegalArgumentException {
        this.cipher.init(true, key);
        return this;
    }

    XTSTweak reset(long tweakValue) throws DataLengthException, IllegalStateException {
        return this.reset(this.tweakFunction.apply(tweakValue));
    }

    XTSTweak reset(byte[] tweakBytes) throws DataLengthException, IllegalStateException {
        this.cipher.processBlock(tweakBytes, 0, this.tweak, 0);
        return this;
    }

    byte[] value() {
        return Arrays.copyOf(this.tweak, this.tweak.length);
    }

    XTSTweak next() {
        long lo = Pack.littleEndianToLong(this.tweak, 0);
        long hi = Pack.littleEndianToLong(this.tweak, 8);
        long fdbk = (hi & Long.MIN_VALUE) == 0L ? 0L : 135L;
        hi = hi << 1 | lo >>> 63;
        lo = lo << 1 ^ fdbk;
        Pack.longToLittleEndian(lo, this.tweak, 0);
        Pack.longToLittleEndian(hi, this.tweak, 8);
        return this;
    }
}

