/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.xtsaes;

import java.util.Objects;
import java.util.function.LongFunction;
import libKonogonka.xtsaes.XTSCore;
import libKonogonka.xtsaes.XTSTweak;
import net.jcip.annotations.NotThreadSafe;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

@NotThreadSafe
public class XTSAESBlockCipher
implements BlockCipher {
    private final XTSCore core;
    private final int blockSize;
    private final int dataUnitSize;
    private long dataUnit;
    private int index;

    XTSAESBlockCipher(XTSCore core, int blockSize, int dataUnitSize, long dataUnit, int index) {
        this.core = Objects.requireNonNull(core, "core");
        this.blockSize = blockSize;
        this.dataUnitSize = dataUnitSize;
        this.dataUnit = dataUnit;
        this.index = index;
    }

    XTSAESBlockCipher(XTSCore core, LongFunction<byte[]> tweakValueFunction, int dataUnitSize) {
        this(new XTSCore(new XTSTweak(tweakValueFunction)), core.getBlockSize(), dataUnitSize, 0L, 0);
    }

    public XTSAESBlockCipher(boolean isDefault, LongFunction<byte[]> tweakValueFunction, int dataUnitSize) {
        this(new XTSCore(isDefault), tweakValueFunction, dataUnitSize);
    }

    public XTSAESBlockCipher(boolean isDefault, int dataUnitSize) {
        this(new XTSCore(isDefault), isDefault ? XTSTweak::defaultTweakFunction : XTSTweak::nintTweakFunction, dataUnitSize);
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof KeyParameter) {
            this.core.init(forEncryption, (KeyParameter)params);
            return;
        }
        throw new IllegalArgumentException("invalid params: " + params.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return this.core.getAlgorithmName();
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.index == 0) {
            this.core.reset(this.dataUnit);
        }
        if ((this.index += this.blockSize) == this.dataUnitSize) {
            ++this.dataUnit;
            this.index = 0;
        }
        return this.core.processBlock(in, inOff, out, outOff);
    }

    @Override
    public void reset() {
        this.index = 0;
        this.dataUnit = 0L;
    }
}

