/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.other.System2.ini1;

import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.RainbowDump;
import libKonogonka.fs.NPDM.KernelAccessControlProvider;
import libKonogonka.fs.NSO.SegmentHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KIP1Header {
    private static final Logger log = LogManager.getLogger(KIP1Header.class);
    private final String magic;
    private final String name;
    private final byte[] programId;
    private final int version;
    private final byte mainThreadPriority;
    private final byte mainThreadCoreNumber;
    private final byte reserved1;
    private final byte flags;
    private final SegmentHeader textSegmentHeader;
    private final int threadAffinityMask;
    private final SegmentHeader roDataSegmentHeader;
    private final int mainThreadStackSize;
    private final SegmentHeader rwDataSegmentHeader;
    private final byte[] reserved2;
    private final SegmentHeader bssSegmentHeader;
    private final byte[] reserved3;
    private final KernelAccessControlProvider kernelCapabilityData;

    public KIP1Header(byte[] kip1HeaderBytes) throws Exception {
        this.magic = new String(kip1HeaderBytes, 0, 4);
        this.name = new String(kip1HeaderBytes, 4, 12).trim();
        this.programId = Arrays.copyOfRange(kip1HeaderBytes, 16, 24);
        this.version = Converter.getLEint(kip1HeaderBytes, 24);
        this.mainThreadPriority = kip1HeaderBytes[28];
        this.mainThreadCoreNumber = kip1HeaderBytes[29];
        this.reserved1 = kip1HeaderBytes[30];
        this.flags = kip1HeaderBytes[31];
        this.textSegmentHeader = new SegmentHeader(kip1HeaderBytes, 32);
        this.threadAffinityMask = Converter.getLEint(kip1HeaderBytes, 44);
        this.roDataSegmentHeader = new SegmentHeader(kip1HeaderBytes, 48);
        this.mainThreadStackSize = Converter.getLEint(kip1HeaderBytes, 60);
        this.rwDataSegmentHeader = new SegmentHeader(kip1HeaderBytes, 64);
        this.reserved2 = Arrays.copyOfRange(kip1HeaderBytes, 76, 80);
        this.bssSegmentHeader = new SegmentHeader(kip1HeaderBytes, 80);
        this.reserved3 = Arrays.copyOfRange(kip1HeaderBytes, 92, 128);
        this.kernelCapabilityData = new KernelAccessControlProvider(Arrays.copyOfRange(kip1HeaderBytes, 128, 256));
    }

    public String getMagic() {
        return this.magic;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getProgramId() {
        return this.programId;
    }

    public int getVersion() {
        return this.version;
    }

    public byte getMainThreadPriority() {
        return this.mainThreadPriority;
    }

    public byte getMainThreadCoreNumber() {
        return this.mainThreadCoreNumber;
    }

    public byte getReserved1() {
        return this.reserved1;
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isTextCompressFlag() {
        return (this.flags & 1) == 1;
    }

    public boolean isRoDataCompressFlag() {
        return (this.flags >> 1 & 1) == 1;
    }

    public boolean isRwDataCompressFlag() {
        return (this.flags >> 2 & 1) == 1;
    }

    public boolean is64BitInstruction() {
        return (this.flags >> 3 & 1) == 1;
    }

    public boolean isAddressSpace64Bit() {
        return (this.flags >> 4 & 1) == 1;
    }

    public boolean isUseSecureMemory() {
        return (this.flags >> 5 & 1) == 1;
    }

    public SegmentHeader getTextSegmentHeader() {
        return this.textSegmentHeader;
    }

    public int getThreadAffinityMask() {
        return this.threadAffinityMask;
    }

    public SegmentHeader getRoDataSegmentHeader() {
        return this.roDataSegmentHeader;
    }

    public int getMainThreadStackSize() {
        return this.mainThreadStackSize;
    }

    public SegmentHeader getRwDataSegmentHeader() {
        return this.rwDataSegmentHeader;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public SegmentHeader getBssSegmentHeader() {
        return this.bssSegmentHeader;
    }

    public byte[] getReserved3() {
        return this.reserved3;
    }

    public KernelAccessControlProvider getKernelCapabilityData() {
        return this.kernelCapabilityData;
    }

    public void printDebug() {
        StringBuilder mapIoOrNormalRange = new StringBuilder();
        StringBuilder interruptPairs = new StringBuilder();
        StringBuilder syscallMasks = new StringBuilder();
        this.kernelCapabilityData.getMapIoOrNormalRange().forEach((bytes, aBoolean) -> {
            mapIoOrNormalRange.append("    ");
            mapIoOrNormalRange.append(Converter.byteArrToHexStringAsLE(bytes));
            mapIoOrNormalRange.append(" : ");
            mapIoOrNormalRange.append(aBoolean);
            mapIoOrNormalRange.append("\n");
        });
        this.kernelCapabilityData.getInterruptPairs().forEach((aInteger, bytes) -> {
            interruptPairs.append("  #");
            interruptPairs.append(aInteger);
            for (byte[] innerArray : bytes) {
                interruptPairs.append("\n    |- ");
                interruptPairs.append(Converter.byteArrToHexStringAsLE(innerArray));
            }
            interruptPairs.append("\n");
        });
        this.kernelCapabilityData.getSyscallMasks().forEach((aByte, bytes) -> {
            syscallMasks.append("    ");
            syscallMasks.append(String.format("0x%x", aByte));
            syscallMasks.append(" : ");
            syscallMasks.append(Converter.byteArrToHexStringAsLE(bytes));
            syscallMasks.append("\n");
        });
        log.debug("..:: KIP1 ::..\nMagic                            : " + this.magic + "\nName                             : " + this.name + "\nProgramId                        : " + Converter.byteArrToHexStringAsLE(this.programId) + "\nVersion                          : " + RainbowDump.formatDecHexString(this.version) + "\nMain thread priority             : " + String.format("0x%x", this.mainThreadPriority) + "\nMain thread core number          : " + String.format("0x%x", this.mainThreadCoreNumber) + "\nReserved 1                       : " + String.format("0x%x", this.reserved1) + "\nFlags                            : " + Converter.byteToBinaryString(this.flags) + "\n   0| .text compress             : " + ((this.flags & 1) == 1 ? "YES" : "NO") + "\n   1| .ro compress               : " + ((this.flags >> 1 & 1) == 1 ? "YES" : "NO") + "\n   2| .rw compress               : " + ((this.flags >> 2 & 1) == 1 ? "YES" : "NO") + "\n   3| Is 64-bit instruction      : " + ((this.flags >> 3 & 1) == 1 ? "YES" : "NO") + "\n   4| Process addr. space 64-bit : " + ((this.flags >> 4 & 1) == 1 ? "YES" : "NO") + "\n   5| Use secure memory          : " + ((this.flags >> 5 & 1) == 1 ? "YES" : "NO") + "\n.text segment header\n   Segment offset                : " + RainbowDump.formatDecHexString(this.textSegmentHeader.getSegmentOffset()) + "\n   Memory offset                 : " + RainbowDump.formatDecHexString(this.textSegmentHeader.getMemoryOffset()) + "\n   Size                          : " + RainbowDump.formatDecHexString(this.textSegmentHeader.getSize()) + "\nThread affinity mask             : " + RainbowDump.formatDecHexString(this.threadAffinityMask) + "\n.ro segment header\n   Segment offset                : " + RainbowDump.formatDecHexString(this.roDataSegmentHeader.getSegmentOffset()) + "\n   Memory offset                 : " + RainbowDump.formatDecHexString(this.roDataSegmentHeader.getMemoryOffset()) + "\n   Size                          : " + RainbowDump.formatDecHexString(this.roDataSegmentHeader.getSize()) + "\nMain thread stack size           : " + RainbowDump.formatDecHexString(this.mainThreadStackSize) + "\n.rw segment header\n   Segment offset                : " + RainbowDump.formatDecHexString(this.rwDataSegmentHeader.getSegmentOffset()) + "\n   Memory offset                 : " + RainbowDump.formatDecHexString(this.rwDataSegmentHeader.getMemoryOffset()) + "\n   Size                          : " + RainbowDump.formatDecHexString(this.rwDataSegmentHeader.getSize()) + "\nReserved 2                       : " + Converter.byteArrToHexStringAsLE(this.reserved2) + "\n.bss segment header\n   Segment offset                : " + RainbowDump.formatDecHexString(this.bssSegmentHeader.getSegmentOffset()) + "\n   Memory offset                 : " + RainbowDump.formatDecHexString(this.bssSegmentHeader.getMemoryOffset()) + "\n   Size                          : " + RainbowDump.formatDecHexString(this.bssSegmentHeader.getSize()) + "\nReserved 3                       : " + Converter.byteArrToHexStringAsLE(this.reserved3) + "\nKernel capability data\n  Kernel flags available?        : " + this.kernelCapabilityData.isKernelFlagsAvailable() + "\n          |- CPU ID Hi           : " + this.kernelCapabilityData.getKernelFlagCpuIdHi() + "\n          |- CPU ID Low          : " + this.kernelCapabilityData.getKernelFlagCpuIdLo() + "\n          |- Thread priority Hi  : " + this.kernelCapabilityData.getKernelFlagThreadPrioHi() + "\n          |- Thread priority Low : " + this.kernelCapabilityData.getKernelFlagThreadPrioLo() + "\nMap IO or Normal Range:\n" + mapIoOrNormalRange + "Interrupt pairs\n" + interruptPairs + "Map normal page                  : " + Converter.byteArrToHexStringAsLE(this.kernelCapabilityData.getMapNormalPage()) + "\nApplication type                 : " + RainbowDump.formatDecHexString(this.kernelCapabilityData.getApplicationType()) + "\n  Kernel rel. version available? : " + this.kernelCapabilityData.isKernelRelVersionAvailable() + "\n          |- Version Major       : " + this.kernelCapabilityData.getKernelRelVersionMajor() + "\n          |- Version Minor       : " + this.kernelCapabilityData.getKernelRelVersionMinor() + "\nHandle table size                : " + RainbowDump.formatDecHexString(this.kernelCapabilityData.getHandleTableSize()) + "\n  Debug flags available?         : " + this.kernelCapabilityData.isDebugFlagsAvailable() + "\n          |- Can be debugged     : " + this.kernelCapabilityData.isCanBeDebugged() + "\n          |- Can debug others    : " + this.kernelCapabilityData.isCanDebugOthers() + "\nSyscall masks\n" + syscallMasks);
    }
}

