/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.XCI;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import libKonogonka.fs.XCI.HFS0File;
import libKonogonka.fs.XCI.HFS0Provider;
import libKonogonka.fs.XCI.XCIGamecardCert;
import libKonogonka.fs.XCI.XCIGamecardHeader;
import libKonogonka.fs.XCI.XCIGamecardInfo;

public class XCIProvider {
    private final XCIGamecardHeader xciGamecardHeader;
    private final XCIGamecardInfo xciGamecardInfo;
    private final XCIGamecardCert xciGamecardCert;
    private final HFS0Provider hfs0ProviderMain;
    private HFS0Provider hfs0ProviderUpdate;
    private HFS0Provider hfs0ProviderNormal;
    private HFS0Provider hfs0ProviderSecure;
    private HFS0Provider hfs0ProviderLogo;

    public XCIProvider(File file, String XCI_HEADER_KEY) throws Exception {
        RandomAccessFile raf;
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fnfe) {
            throw new Exception("XCI File not found: \n  " + fnfe.getMessage());
        }
        if (file.length() < 61456L) {
            throw new Exception("XCI File is too small.");
        }
        try {
            byte[] gamecardHeaderBytes = new byte[400];
            byte[] gamecardInfoBytes = new byte[112];
            byte[] gamecardCertBytes = new byte[512];
            if (raf.read(gamecardHeaderBytes) != 400) {
                raf.close();
                throw new Exception("XCI Can't read Gamecard Header bytes.");
            }
            this.xciGamecardHeader = new XCIGamecardHeader(gamecardHeaderBytes);
            if (raf.read(gamecardInfoBytes) != 112) {
                raf.close();
                throw new Exception("XCI Can't read Gamecard Header bytes.");
            }
            this.xciGamecardInfo = new XCIGamecardInfo(gamecardInfoBytes, this.xciGamecardHeader.getGcInfoIV(), XCI_HEADER_KEY);
            raf.seek(28672L);
            if (raf.read(gamecardCertBytes) != 512) {
                raf.close();
                throw new Exception("XCI Can't read Gamecard certificate bytes.");
            }
            this.xciGamecardCert = new XCIGamecardCert(gamecardCertBytes);
            this.hfs0ProviderMain = new HFS0Provider(61440L, raf, file);
            if (this.hfs0ProviderMain.getFilesCount() < 3) {
                raf.close();
                throw new Exception("XCI Can't read Gamecard certificate bytes.");
            }
            for (HFS0File hfs0File : this.hfs0ProviderMain.getHfs0Files()) {
                String partition = hfs0File.getName();
                if (partition.equals("update")) {
                    this.hfs0ProviderUpdate = new HFS0Provider(this.hfs0ProviderMain.getRawFileDataStart() + hfs0File.getOffset(), raf, file);
                    continue;
                }
                if (partition.equals("normal")) {
                    this.hfs0ProviderNormal = new HFS0Provider(this.hfs0ProviderMain.getRawFileDataStart() + hfs0File.getOffset(), raf, file);
                    continue;
                }
                if (partition.equals("secure")) {
                    this.hfs0ProviderSecure = new HFS0Provider(this.hfs0ProviderMain.getRawFileDataStart() + hfs0File.getOffset(), raf, file);
                    continue;
                }
                if (!partition.equals("logo")) continue;
                this.hfs0ProviderLogo = new HFS0Provider(this.hfs0ProviderMain.getRawFileDataStart() + hfs0File.getOffset(), raf, file);
            }
            raf.close();
        }
        catch (IOException ioe) {
            throw new Exception("XCI Failed file analyze for [" + file.getName() + "]\n  " + ioe.getMessage());
        }
    }

    public XCIGamecardHeader getGCHeader() {
        return this.xciGamecardHeader;
    }

    public XCIGamecardInfo getGCInfo() {
        return this.xciGamecardInfo;
    }

    public XCIGamecardCert getGCCert() {
        return this.xciGamecardCert;
    }

    public HFS0Provider getHfs0ProviderMain() {
        return this.hfs0ProviderMain;
    }

    public HFS0Provider getHfs0ProviderUpdate() {
        return this.hfs0ProviderUpdate;
    }

    public HFS0Provider getHfs0ProviderNormal() {
        return this.hfs0ProviderNormal;
    }

    public HFS0Provider getHfs0ProviderSecure() {
        return this.hfs0ProviderSecure;
    }

    public HFS0Provider getHfs0ProviderLogo() {
        return this.hfs0ProviderLogo;
    }
}

