/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.PFS0;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import libKonogonka.RainbowDump;
import libKonogonka.aesctr.InFileStreamProducer;
import libKonogonka.fs.ExportAble;
import libKonogonka.fs.ISuperProvider;
import libKonogonka.fs.NCA.NCASectionTableBlock.SuperBlockPFS0;
import libKonogonka.fs.PFS0.PFS0Header;
import libKonogonka.fs.PFS0.PFS0subFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PFS0Provider
extends ExportAble
implements ISuperProvider {
    private static final Logger log = LogManager.getLogger(PFS0Provider.class);
    private final long rawBlockDataStart;
    private long offsetPositionInFile;
    private final InFileStreamProducer producer;
    private SuperBlockPFS0 superBlockPFS0;
    private long mediaStartOffset;
    private final PFS0Header header;
    private LinkedList<byte[]> pfs0SHA256hashes;

    public PFS0Provider(File nspFile) throws Exception {
        this.producer = new InFileStreamProducer(nspFile);
        this.stream = this.producer.produce();
        this.header = new PFS0Header(this.stream);
        this.rawBlockDataStart = 16L + (long)this.header.getFilesCount() * 24L + (long)this.header.getStringTableSize();
    }

    public PFS0Provider(InFileStreamProducer producer, long offsetPositionInFile, SuperBlockPFS0 superBlockPFS0, long mediaStartOffset) throws Exception {
        this.producer = producer;
        this.offsetPositionInFile = offsetPositionInFile;
        this.superBlockPFS0 = superBlockPFS0;
        this.mediaStartOffset = mediaStartOffset;
        this.stream = producer.produce();
        long toSkip = offsetPositionInFile + superBlockPFS0.getHashTableOffset();
        if (toSkip != this.stream.skip(toSkip)) {
            throw new Exception("Can't skip bytes prior Hash Table offset");
        }
        this.collectHashes();
        this.stream = producer.produce();
        toSkip = offsetPositionInFile + superBlockPFS0.getPfs0offset();
        if (toSkip != this.stream.skip(toSkip)) {
            throw new Exception("Can't skip bytes prior PFS0 offset");
        }
        this.header = new PFS0Header(this.stream);
        this.rawBlockDataStart = superBlockPFS0.getPfs0offset() + 16L + (long)this.header.getFilesCount() * 24L + (long)this.header.getStringTableSize();
    }

    private void collectHashes() throws Exception {
        this.pfs0SHA256hashes = new LinkedList();
        long hashTableOffset = this.superBlockPFS0.getHashTableOffset();
        long hashTableSize = this.superBlockPFS0.getHashTableSize();
        if (hashTableOffset > 0L && hashTableOffset != this.stream.skip(hashTableOffset)) {
            throw new Exception("Unable to skip bytes till Hash Table Offset: " + hashTableOffset);
        }
        int i = 0;
        while ((long)i < hashTableSize / 32L) {
            byte[] sectionHash = new byte[32];
            if (32 != this.stream.read(sectionHash)) {
                throw new Exception("Unable to read hash");
            }
            this.pfs0SHA256hashes.add(sectionHash);
            ++i;
        }
    }

    public boolean isEncrypted() {
        return this.producer.isEncrypted();
    }

    public PFS0Header getHeader() {
        return this.header;
    }

    @Override
    public long getRawFileDataStart() {
        return this.rawBlockDataStart;
    }

    @Override
    public boolean exportContent(String saveToLocation, String subFileName) {
        PFS0subFile[] pfs0subFiles = this.header.getPfs0subFiles();
        for (int i = 0; i < pfs0subFiles.length; ++i) {
            if (!pfs0subFiles[i].getName().equals(subFileName)) continue;
            return this.exportContent(saveToLocation, i);
        }
        return false;
    }

    @Override
    public boolean exportContent(String saveToLocation, int subFileNumber) {
        try {
            PFS0subFile subFile = this.header.getPfs0subFiles()[subFileNumber];
            this.stream = this.producer.produce();
            long toSkip = subFile.getOffset() + this.mediaStartOffset * 512L + this.rawBlockDataStart;
            return this.export(saveToLocation, subFile.getName(), toSkip, subFile.getSize());
        }
        catch (Exception e) {
            log.error("File export failure", (Throwable)e);
            return false;
        }
    }

    @Override
    public InFileStreamProducer getStreamProducer(String subFileName) throws FileNotFoundException {
        PFS0subFile[] pfs0subFiles = this.header.getPfs0subFiles();
        for (int i = 0; i < pfs0subFiles.length; ++i) {
            if (!pfs0subFiles[i].getName().equals(subFileName)) continue;
            return this.getStreamProducer(i);
        }
        throw new FileNotFoundException("No file with such name exists: " + subFileName);
    }

    @Override
    public InFileStreamProducer getStreamProducer(int subFileNumber) {
        PFS0subFile subFile = this.header.getPfs0subFiles()[subFileNumber];
        long subFileOffset = subFile.getOffset() + this.mediaStartOffset * 512L + this.rawBlockDataStart;
        return this.producer.getSuccessor(subFileOffset);
    }

    public LinkedList<byte[]> getPfs0SHA256hashes() {
        return this.pfs0SHA256hashes;
    }

    @Override
    public File getFile() {
        return this.producer.getFile();
    }

    public void printDebug() {
        log.debug(".:: PFS0Provider ::.\nFile name:                " + this.getFile().getName() + "\nRaw block data start      " + RainbowDump.formatDecHexString(this.rawBlockDataStart) + "\nOffset position in file   " + RainbowDump.formatDecHexString(this.offsetPositionInFile) + "\nMedia Start Offset        " + RainbowDump.formatDecHexString(this.mediaStartOffset) + "\n");
        this.header.printDebug();
    }
}

