/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NCA.NCASectionTableBlock;

import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.fs.NCA.NCASectionTableBlock.BucketTreeHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SparseInfo {
    private static final Logger log = LogManager.getLogger(SparseInfo.class);
    private final long offset;
    private final long size;
    private final BucketTreeHeader bktr;
    private final long physicalOffset;
    private final byte[] generation;
    private final byte[] unknown;

    SparseInfo(byte[] rawTable) {
        this.offset = Converter.getLElong(rawTable, 0);
        this.size = Converter.getLElong(rawTable, 8);
        this.bktr = new BucketTreeHeader(Arrays.copyOfRange(rawTable, 16, 32));
        this.physicalOffset = Converter.getLElong(rawTable, 32);
        this.generation = Arrays.copyOfRange(rawTable, 40, 42);
        this.unknown = Arrays.copyOfRange(rawTable, 42, 48);
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public String getBktrMagic() {
        return this.bktr.getMagic();
    }

    public int getBktrVersion() {
        return this.bktr.getVersion();
    }

    public int getBktrEntryCount() {
        return this.bktr.getEntryCount();
    }

    public byte[] getBktrUnknown() {
        return this.bktr.getUnknown();
    }

    public long getPhysicalOffset() {
        return this.physicalOffset;
    }

    public byte[] getGeneration() {
        return this.generation;
    }

    public byte[] getUnknown() {
        return this.unknown;
    }

    public void printDebug() {
        log.debug("SparseInfo:\nOffset            : " + this.offset + "\nSize              : " + this.size + "\n");
        this.bktr.printDebug();
        log.debug("\nPhysicalOffset    : " + this.physicalOffset + "\nGeneration        : " + Converter.byteArrToHexStringAsLE(this.generation) + "\nUnknown           : " + Converter.byteArrToHexStringAsLE(this.unknown) + "\n");
    }
}

