/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.ModelControllers.Log;
import nsusbloader.NSLDataTypes.EFileStatus;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.usb.GoldLeaf_010;
import nsusbloader.com.usb.GoldLeaf_05;
import nsusbloader.com.usb.GoldLeaf_07;
import nsusbloader.com.usb.GoldLeaf_08;
import nsusbloader.com.usb.TinFoil;
import nsusbloader.com.usb.TransferModule;
import nsusbloader.com.usb.UsbConnect;
import org.usb4java.DeviceHandle;

public class UsbCommunications
extends CancellableRunnable {
    private final ILogPrinter logPrinter;
    private final LinkedHashMap<String, File> nspMap;
    private final String protocol;
    private final boolean nspFilterForGl;

    public UsbCommunications(List<File> nspList, String protocol, boolean filterNspFilesOnlyForGl) {
        this.protocol = protocol;
        this.nspFilterForGl = filterNspFilesOnlyForGl;
        this.nspMap = new LinkedHashMap();
        for (File f : nspList) {
            this.nspMap.put(f.getName(), f);
        }
        this.logPrinter = Log.getPrinter(EModule.USB_NET_TRANSFERS);
    }

    @Override
    public void run() {
        TransferModule module;
        this.print("\tStart");
        UsbConnect usbConnect = UsbConnect.connectHomebrewMode(this.logPrinter);
        if (!usbConnect.isConnected()) {
            this.close(EFileStatus.FAILED);
            return;
        }
        DeviceHandle handler = usbConnect.getNsHandler();
        switch (this.protocol) {
            case "TinFoil": {
                module = new TinFoil(handler, this.nspMap, this, this.logPrinter);
                break;
            }
            case "GoldLeafv0.10+": {
                module = new GoldLeaf_010(handler, this.nspMap, this, this.logPrinter, this.nspFilterForGl);
                break;
            }
            case "GoldLeafv0.8-0.9": {
                module = new GoldLeaf_08(handler, this.nspMap, this, this.logPrinter, this.nspFilterForGl);
                break;
            }
            case "GoldLeafv0.7.x": {
                module = new GoldLeaf_07(handler, this.nspMap, this, this.logPrinter, this.nspFilterForGl);
                break;
            }
            default: {
                module = new GoldLeaf_05(handler, this.nspMap, this, this.logPrinter);
            }
        }
        usbConnect.close();
        this.close(module.getStatus());
    }

    private void close(EFileStatus status) {
        this.logPrinter.update(this.nspMap, status);
        this.print("\tEnd");
        this.logPrinter.close();
    }

    private void print(String message) {
        try {
            this.logPrinter.print(message, EMsgType.INFO);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

