/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EFileStatus;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.helpers.NSSplitReader;
import nsusbloader.com.usb.TransferModule;
import nsusbloader.com.usb.UsbErrorCodes;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;

class TinFoil
extends TransferModule {
    private static final byte[] TUL0 = new byte[]{84, 85, 76, 48};
    private static final byte[] MAGIC = new byte[]{84, 85, 67, 48};
    private static final byte CMD_EXIT = 0;
    private static final byte CMD_FILE_RANGE_DEFAULT = 1;
    private static final byte CMD_FILE_RANGE_ALTERNATIVE = 2;

    TinFoil(DeviceHandle handler, LinkedHashMap<String, File> nspMap, CancellableRunnable task, ILogPrinter logPrinter) {
        super(handler, nspMap, task, logPrinter);
        this.print("======== Awoo Installer and compatibles ========", EMsgType.INFO);
        if (!this.sendListOfFiles()) {
            return;
        }
        if (this.proceedCommands()) {
            this.status = EFileStatus.UPLOADED;
        }
    }

    private boolean sendListOfFiles() {
        String fileNamesListToSend = this.getFileNamesToSend();
        byte[] nspListNames = this.getFileNamesToSendAsBytes(fileNamesListToSend);
        byte[] nspListNamesSize = this.getFileNamesLengthToSendAsBytes(nspListNames);
        byte[] padding = new byte[8];
        if (this.writeUsb(TUL0)) {
            this.print("Send list of files: handshake   [1/4]", EMsgType.FAIL);
            return false;
        }
        if (this.writeUsb(nspListNamesSize)) {
            this.print("Send list of files: list length [2/4]", EMsgType.FAIL);
            return false;
        }
        if (this.writeUsb(padding)) {
            this.print("Send list of files: padding     [3/4]", EMsgType.FAIL);
            return false;
        }
        if (this.writeUsb(nspListNames)) {
            this.print("Send list of files: list itself [4/4]", EMsgType.FAIL);
            return false;
        }
        this.print("Send list of files complete.", EMsgType.PASS);
        return true;
    }

    private String getFileNamesToSend() {
        StringBuilder fileNamesListBuilder = new StringBuilder();
        for (String nspFileName : this.nspMap.keySet()) {
            fileNamesListBuilder.append(nspFileName);
            fileNamesListBuilder.append('\n');
        }
        return fileNamesListBuilder.toString();
    }

    private byte[] getFileNamesToSendAsBytes(String fileNamesListToSend) {
        return fileNamesListToSend.getBytes(StandardCharsets.UTF_8);
    }

    private byte[] getFileNamesLengthToSendAsBytes(byte[] fileNamesListToSendAsBytes) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(fileNamesListToSendAsBytes.length);
        return byteBuffer.array();
    }

    private boolean proceedCommands() {
        this.print("Awaiting for NS commands.", EMsgType.INFO);
        try {
            while (true) {
                byte[] deviceReply;
                if (!this.isReplyValid(deviceReply = this.readUsb())) {
                    continue;
                }
                byte command = this.getCommandFromReply(deviceReply);
                switch (command) {
                    case 0: {
                        this.print("Transfer complete.", EMsgType.PASS);
                        return true;
                    }
                    case 1: 
                    case 2: {
                        if (!this.fileRangeCmd()) break;
                        return false;
                    }
                }
            }
        }
        catch (Exception e) {
            this.print(e.getMessage(), EMsgType.INFO);
            return false;
        }
    }

    private boolean isReplyValid(byte[] reply) {
        return Arrays.equals(Arrays.copyOfRange(reply, 0, 4), MAGIC);
    }

    private byte getCommandFromReply(byte[] reply) {
        return reply[8];
    }

    private boolean fileRangeCmd() {
        try {
            byte[] receivedArray = this.readUsb();
            byte[] sizeAsBytes = Arrays.copyOfRange(receivedArray, 0, 8);
            long size = ByteBuffer.wrap(sizeAsBytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
            long offset = ByteBuffer.wrap(Arrays.copyOfRange(receivedArray, 8, 16)).order(ByteOrder.LITTLE_ENDIAN).getLong();
            receivedArray = this.readUsb();
            String nspFileName = new String(receivedArray, StandardCharsets.UTF_8);
            this.print(String.format("Reply to: %s\n         Offset: %-20d 0x%x\n         Size:   %-20d 0x%x", nspFileName, offset, offset, size, size), EMsgType.INFO);
            File nspFile = (File)this.nspMap.get(nspFileName);
            boolean isSplitFile = nspFile.isDirectory();
            if (this.sendMetaInfoForFile(sizeAsBytes)) {
                return true;
            }
            if (isSplitFile) {
                this.sendSplitFile(nspFile, size, offset);
            } else {
                this.sendNormalFile(nspFile, size, offset);
            }
        }
        catch (IOException ioe) {
            this.print("IOException:\n         " + ioe.getMessage(), EMsgType.FAIL);
            ioe.printStackTrace();
            return true;
        }
        catch (ArithmeticException ae) {
            this.print("ArithmeticException (can't cast 'offset end' - 'offsets current' to 'integer'):\n         " + ae.getMessage(), EMsgType.FAIL);
            ae.printStackTrace();
            return true;
        }
        catch (NullPointerException npe) {
            this.print("Application didn't find something important. Make sure you have enough space on medium!\n         " + npe.getMessage(), EMsgType.FAIL);
            npe.printStackTrace();
            return true;
        }
        catch (Exception defe) {
            this.print(defe.getMessage(), EMsgType.FAIL);
            return true;
        }
        return false;
    }

    void sendSplitFile(File nspFile, long size, long offset) throws Exception {
        long currentOffset = 0L;
        int chunk = 0x800000;
        NSSplitReader nsSplitReader = new NSSplitReader(nspFile, size);
        if (nsSplitReader.seek(offset) != offset) {
            throw new IOException("Requested offset is out of file size. Nothing to transmit.");
        }
        while (currentOffset < size) {
            byte[] readBuffer;
            if (currentOffset + (long)chunk >= size) {
                chunk = Math.toIntExact(size - currentOffset);
            }
            if (nsSplitReader.read(readBuffer = new byte[chunk]) != chunk) {
                throw new IOException("Reading from stream suddenly ended.");
            }
            if (this.writeUsb(readBuffer)) {
                throw new IOException("Failure during file transfer.");
            }
            this.logPrinter.updateProgress((double)(currentOffset += (long)chunk) / (double)size);
        }
        nsSplitReader.close();
        this.logPrinter.updateProgress(1.0);
    }

    void sendNormalFile(File nspFile, long size, long offset) throws Exception {
        long currentOffset = 0L;
        int chunk = 0x800000;
        BufferedInputStream bufferedInStream = new BufferedInputStream(new FileInputStream(nspFile));
        if (bufferedInStream.skip(offset) != offset) {
            throw new IOException("Requested offset is out of file size. Nothing to transmit.");
        }
        while (currentOffset < size) {
            byte[] readBuffer;
            if (currentOffset + (long)chunk >= size) {
                chunk = Math.toIntExact(size - currentOffset);
            }
            if (bufferedInStream.read(readBuffer = new byte[chunk]) != chunk) {
                throw new IOException("Reading from stream suddenly ended.");
            }
            if (this.writeUsb(readBuffer)) {
                throw new IOException("Failure during file transfer.");
            }
            this.logPrinter.updateProgress((double)(currentOffset += (long)chunk) / (double)size);
        }
        bufferedInStream.close();
        this.logPrinter.updateProgress(1.0);
    }

    private boolean sendMetaInfoForFile(byte[] sizeAsBytes) {
        byte[] standardReplyBytes = new byte[]{84, 85, 67, 48, 1, 0, 0, 0, 1, 0, 0, 0};
        byte[] twelveZeroBytes = new byte[12];
        if (this.writeUsb(standardReplyBytes)) {
            this.print("Sending response failed [1/3]", EMsgType.FAIL);
            return true;
        }
        if (this.writeUsb(sizeAsBytes)) {
            this.print("Sending response failed [2/3]", EMsgType.FAIL);
            return true;
        }
        if (this.writeUsb(twelveZeroBytes)) {
            this.print("Sending response failed [3/3]", EMsgType.FAIL);
            return true;
        }
        return false;
    }

    private boolean writeUsb(byte[] message) {
        ByteBuffer writeBuffer = ByteBuffer.allocateDirect(message.length);
        writeBuffer.put(message);
        IntBuffer writeBufTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)1, writeBuffer, writeBufTransferred, 5050L);
            switch (result) {
                case 0: {
                    if (writeBufTransferred.get() == message.length) {
                        return false;
                    }
                    this.print("Data transfer issue [write]\n         Requested: " + message.length + "\n         Transferred: " + writeBufTransferred.get(), EMsgType.FAIL);
                    return true;
                }
                case -7: {
                    continue block4;
                }
            }
            this.print("Data transfer issue [write]\n         Returned: " + UsbErrorCodes.getErrCode(result) + "\n         (execution stopped)", EMsgType.FAIL);
            return true;
        }
        this.print("Execution interrupted", EMsgType.INFO);
        return true;
    }

    private byte[] readUsb() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(512);
        IntBuffer readBufTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, readBufTransferred, 1000L);
            switch (result) {
                case 0: {
                    int trans = readBufTransferred.get();
                    byte[] receivedBytes = new byte[trans];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    continue block4;
                }
            }
            throw new Exception("Data transfer issue [read]\n         Returned: " + UsbErrorCodes.getErrCode(result) + "\n         (execution stopped)");
        }
        throw new InterruptedException("Execution interrupted");
    }
}

