/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.helpers;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class NSSplitReader
implements Closeable {
    private final String splitFileDir;
    private final long referenceSplitChunkSize;
    private byte subFileNum;
    private long curPosition;
    private BufferedInputStream biStream;

    public NSSplitReader(File file, long seekToPosition) throws IOException, NullPointerException {
        this.splitFileDir = file.getAbsolutePath() + File.separator;
        File subFile = new File(file.getAbsolutePath() + File.separator + "00");
        if (!file.exists()) {
            throw new FileNotFoundException("File not found on " + file.getAbsolutePath() + File.separator + "00");
        }
        this.referenceSplitChunkSize = subFile.length();
        this.subFileNum = (byte)(seekToPosition / this.referenceSplitChunkSize);
        this.biStream = new BufferedInputStream(new FileInputStream(this.splitFileDir + String.format("%02d", this.subFileNum)));
        this.curPosition = seekToPosition;
        if ((seekToPosition -= this.referenceSplitChunkSize * (long)this.subFileNum) != this.biStream.skip(seekToPosition)) {
            throw new IOException("Unable to seek to requested position of " + seekToPosition + " for file " + this.splitFileDir + String.format("%02d", this.subFileNum));
        }
    }

    public long seek(long position) throws IOException {
        byte subFileRequested = (byte)(position / this.referenceSplitChunkSize);
        if (subFileRequested != this.subFileNum || this.curPosition > position) {
            this.biStream.close();
            this.biStream = new BufferedInputStream(new FileInputStream(this.splitFileDir + String.format("%02d", subFileRequested)));
            this.subFileNum = subFileRequested;
            this.curPosition = this.referenceSplitChunkSize * (long)subFileRequested;
        }
        long retVal = this.biStream.skip(position - this.curPosition);
        this.curPosition = position;
        return retVal += this.curPosition;
    }

    public int read(byte[] readBuffer) throws IOException, NullPointerException {
        int requested = readBuffer.length;
        if (this.curPosition + (long)requested <= this.referenceSplitChunkSize * (long)(this.subFileNum + 1)) {
            int readPrtOne = this.biStream.read(readBuffer);
            if (readPrtOne < 0) {
                return readPrtOne;
            }
            this.curPosition += (long)readPrtOne;
            return readPrtOne;
        }
        int partOne = (int)(this.referenceSplitChunkSize * (long)(this.subFileNum + 1) - this.curPosition);
        int partTwo = requested - partOne;
        int readPrtOne = this.biStream.read(readBuffer, 0, partOne);
        if (readPrtOne < 0) {
            return readPrtOne;
        }
        this.curPosition += (long)readPrtOne;
        if (readPrtOne != partOne) {
            return readPrtOne;
        }
        this.biStream.close();
        this.subFileNum = (byte)(this.subFileNum + 1);
        this.biStream = new BufferedInputStream(new FileInputStream(this.splitFileDir + String.format("%02d", this.subFileNum)));
        int readPrtTwo = this.biStream.read(readBuffer, partOne, partTwo);
        if (readPrtTwo < 0) {
            return readPrtTwo;
        }
        this.curPosition += (long)readPrtTwo;
        return readPrtOne + readPrtTwo;
    }

    @Override
    public void close() throws IOException {
        if (this.biStream != null) {
            this.biStream.close();
        }
    }
}

