/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import nsusbloader.AppPreferences;
import nsusbloader.cli.IncorrectSetupException;
import nsusbloader.com.usb.UsbCommunications;

public class GoldLeafCli {
    private final String[] arguments;
    private List<File> filesList;
    private String goldLeafVersion;
    private boolean filterForNsp;
    private int parseFileSince = 1;

    GoldLeafCli(String[] arguments) throws InterruptedException, IncorrectSetupException {
        this.arguments = arguments;
        this.checkArguments();
        this.parseGoldLeafVersion();
        this.parseFilesArguments();
        this.runGoldLeafBackend();
    }

    private void checkArguments() throws IncorrectSetupException {
        if (this.arguments == null || this.arguments.length == 0) {
            throw new IncorrectSetupException("No arguments.\nTry 'ns-usbloader -g help' for more information.");
        }
        if (this.arguments.length == 1 && this.isHelpDirective(this.arguments[0])) {
            this.showHelp();
        }
        if (this.arguments.length > 1 && this.arguments[1].equals("filter")) {
            this.filterForNsp = true;
            this.parseFileSince = 2;
        }
    }

    private boolean isHelpDirective(String argument) {
        return argument.equals("help");
    }

    private void showHelp() throws IncorrectSetupException {
        throw new IncorrectSetupException("Usage:\n\tns-usbloader -g ver=<arg1> [filter] FILE1 ...\n\tns-usbloader --goldleaf ver=<arg1> [filter] FILE1 ...\n\nOption:\n\tver=<goldleaf_version>\tDefine GoldLeaf version (mandatory)\n\tfilter\t\t\tShow only *.nsp in GoldLeaf (optional)\n\n" + this.getGlSupportedVersions());
    }

    private String getGlSupportedVersions() {
        StringBuilder builder = new StringBuilder("Supported versions: \n");
        for (String a : AppPreferences.GOLDLEAF_SUPPORTED_VERSIONS) {
            builder.append("\t");
            builder.append(a);
            builder.append("\n");
        }
        return builder.toString();
    }

    private void parseGoldLeafVersion() throws IncorrectSetupException {
        String argument1 = this.arguments[0];
        if (!argument1.startsWith("ver=")) {
            throw new IncorrectSetupException("First argument must be 'ver=<goldleaf_version>'\nTry 'ns-usbloader -g help' for more information.");
        }
        this.goldLeafVersion = argument1.replaceAll("^ver=", "");
        if (this.goldLeafVersion.isEmpty()) {
            throw new IncorrectSetupException("No spaces allowed before or after 'ver=<goldleaf_version>' argument.\nTry 'ns-usbloader -g help' for more information.");
        }
        for (String version : AppPreferences.GOLDLEAF_SUPPORTED_VERSIONS) {
            if (!version.equals(this.goldLeafVersion)) continue;
            return;
        }
        throw new IncorrectSetupException("GoldLeaf " + this.goldLeafVersion + " is not supported.\n" + this.getGlSupportedVersions());
    }

    private void parseFilesArguments() throws IncorrectSetupException {
        this.filesList = new ArrayList<File>();
        while (this.parseFileSince < this.arguments.length) {
            File file = new File(this.arguments[this.parseFileSince]);
            if (file.exists()) {
                this.filesList.add(file);
            }
            ++this.parseFileSince;
        }
        if (this.filesList.size() == 0 && this.goldLeafVersion.equals("v0.5")) {
            throw new IncorrectSetupException("File(s) doesn't exist but should be set for GoldLeaf v0.5.\nTry 'ns-usbloader -g help' for more information.");
        }
    }

    private void runGoldLeafBackend() throws InterruptedException {
        UsbCommunications task = new UsbCommunications(this.filesList, "GoldLeaf" + this.goldLeafVersion, this.filterForNsp);
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
        thread.join();
    }
}

