/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.splitmerge;

import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;

public class MultithreadingPrintAdapter {
    private final ILogPrinter printer;
    private long totalFilesSize;
    private long bytesComplete;

    public MultithreadingPrintAdapter(ILogPrinter printer) {
        this.printer = printer;
    }

    public void print(String message, EMsgType type) throws InterruptedException {
        this.printer.print(message, type);
    }

    public void reportFileSize(long fileSize) {
        this.totalFilesSize += fileSize;
    }

    public void updateProgressBySize(long chunkSize) throws InterruptedException {
        this.bytesComplete += chunkSize;
        this.printer.updateProgress((double)this.bytesComplete / (double)this.totalFilesSize);
    }
}

