/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.stream.Collectors;
import libKonogonka.Converter;
import libKonogonka.KeyChainHolder;
import libKonogonka.aesctr.InFileStreamProducer;
import libKonogonka.fs.NCA.NCAProvider;
import libKonogonka.fs.RomFs.FileSystemEntry;
import libKonogonka.fs.RomFs.RomFsProvider;
import libKonogonka.fs.other.System2.System2Provider;
import libKonogonka.fs.other.System2.ini1.Ini1Provider;
import libKonogonka.fs.other.System2.ini1.KIP1Provider;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.patches.BinToAsmPrinter;
import nsusbloader.Utilities.patches.fs.FsIniMaker;
import nsusbloader.Utilities.patches.fs.finders.HeuristicFsWizard;

public class FsPatch {
    private static final byte[] HEADER = "PATCH".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FOOTER = "EOF".getBytes(StandardCharsets.US_ASCII);
    private final NCAProvider ncaProvider;
    private final String saveToLocation;
    private final KeyChainHolder keyChainHolder;
    private final ILogPrinter logPrinter;
    private String patchName;
    private byte[] _textSection;
    private boolean filesystemTypeFat32;
    private HeuristicFsWizard wizard;

    FsPatch(NCAProvider ncaProvider, String saveToLocation, KeyChainHolder keyChainHolder, ILogPrinter logPrinter) throws Exception {
        this.ncaProvider = ncaProvider;
        this.saveToLocation = saveToLocation;
        this.keyChainHolder = keyChainHolder;
        this.logPrinter = logPrinter;
        KIP1Provider kip1Provider = this.getKIP1Provider();
        this.getPatchName(kip1Provider);
        this.getTextSection(kip1Provider);
        this.checkFirmwareVersion();
        this.getFilesystemType();
        this.findAllOffsets();
        this.mkDirs();
        this.writeFile();
        new FsIniMaker(logPrinter, saveToLocation, this._textSection, this.wizard.getOffset1(), this.wizard.getOffset2(), ncaProvider.getSdkVersion(), this.patchName, this.filesystemTypeFat32);
        logPrinter.print("                  == Debug information ==\n" + this.wizard.getDebug(), EMsgType.NULL);
    }

    private KIP1Provider getKIP1Provider() throws Exception {
        FileSystemEntry package2FsEntry;
        RomFsProvider romFsProvider = this.ncaProvider.getNCAContentProvider(0).getRomfs();
        InFileStreamProducer producer = romFsProvider.getStreamProducer(package2FsEntry = (FileSystemEntry)((FileSystemEntry)romFsProvider.getRootEntry().getContent().stream().filter(e -> e.getName().equals("nx")).collect(Collectors.toList()).get(0)).getContent().stream().filter(e -> e.getName().equals("package2")).collect(Collectors.toList()).get(0));
        System2Provider system2Provider = new System2Provider(producer, this.keyChainHolder);
        Ini1Provider ini1Provider = system2Provider.getIni1Provider();
        KIP1Provider kip1Provider = (KIP1Provider)ini1Provider.getKip1List().stream().filter(provider -> provider.getHeader().getName().startsWith("FS")).collect(Collectors.toList()).get(0);
        if (kip1Provider == null) {
            throw new Exception("No FS KIP1");
        }
        return kip1Provider;
    }

    private void getPatchName(KIP1Provider kip1Provider) throws Exception {
        int kip1EncryptedSize = (int)kip1Provider.getSize();
        byte[] kip1EncryptedRaw = new byte[kip1EncryptedSize];
        try (BufferedInputStream kip1ProviderStream = kip1Provider.getStreamProducer().produce();){
            if (kip1EncryptedSize != kip1ProviderStream.read(kip1EncryptedRaw)) {
                throw new Exception("Unencrypted FS KIP1 read failure");
            }
        }
        byte[] sha256ofKip1 = MessageDigest.getInstance("SHA-256").digest(kip1EncryptedRaw);
        this.patchName = Converter.byteArrToHexStringAsLE(sha256ofKip1, true) + ".ips";
    }

    private void getTextSection(KIP1Provider kip1Provider) throws Exception {
        this._textSection = kip1Provider.getAsDecompressed().getTextRaw();
    }

    private void checkFirmwareVersion() throws Exception {
        byte[] byteSdkVersion = this.ncaProvider.getSdkVersion();
        long fwVersion = Long.parseLong("" + byteSdkVersion[3] + byteSdkVersion[2] + byteSdkVersion[1] + byteSdkVersion[0]);
        this.logPrinter.print("Internal firmware version: " + byteSdkVersion[3] + "." + byteSdkVersion[2] + "." + byteSdkVersion[1] + "." + byteSdkVersion[0], EMsgType.INFO);
        if (byteSdkVersion[3] < 9 || fwVersion < 9300L) {
            this.logPrinter.print("WARNING! FIRMWARES VERSIONS BEFORE 9.0.0 ARE NOT SUPPORTED! USING PRODUCED ES PATCHES (IF ANY) COULD BREAK SOMETHING! IT'S NEVER BEEN TESTED!", EMsgType.WARNING);
        }
    }

    private void getFilesystemType() throws Exception {
        String titleId = Converter.byteArrToHexStringAsLE(this.ncaProvider.getTitleId());
        this.filesystemTypeFat32 = titleId.equals("0100000000000819");
        if (this.filesystemTypeFat32) {
            this.logPrinter.print("\n\t\t-- [  FAT32  ] --\n", EMsgType.INFO);
        } else {
            this.logPrinter.print("\n\t\t-- [  ExFAT  ] --\n", EMsgType.INFO);
        }
    }

    private void findAllOffsets() throws Exception {
        this.wizard = new HeuristicFsWizard(this._textSection);
        String errorsAndNotes = this.wizard.getErrorsAndNotes();
        if (errorsAndNotes.length() > 0) {
            this.logPrinter.print(errorsAndNotes, EMsgType.WARNING);
        }
    }

    private void mkDirs() {
        File parentFolder = new File(this.saveToLocation + File.separator + "atmosphere" + File.separator + "kip_patches" + File.separator + "fs_patches");
        parentFolder.mkdirs();
    }

    private void writeFile() throws Exception {
        String patchFileLocation = this.saveToLocation + File.separator + "atmosphere" + File.separator + "kip_patches" + File.separator + "fs_patches" + File.separator + this.patchName;
        int offset1 = this.wizard.getOffset1();
        int offset2 = this.wizard.getOffset2();
        ByteBuffer handyFsPatch = ByteBuffer.allocate(256).order(ByteOrder.LITTLE_ENDIAN);
        handyFsPatch.put(HEADER);
        if (offset1 > 0) {
            this.logPrinter.print("Patch component 1 will be used", EMsgType.PASS);
            handyFsPatch.put(this.getPatch1(offset1));
        }
        if (offset2 > 0) {
            this.logPrinter.print("Patch component 2 will be used", EMsgType.PASS);
            handyFsPatch.put(this.getPatch2(offset2));
        }
        handyFsPatch.put(FOOTER);
        byte[] fsPatch = new byte[handyFsPatch.position()];
        ((Buffer)handyFsPatch).rewind();
        handyFsPatch.get(fsPatch);
        try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(Paths.get(patchFileLocation, new String[0]), new OpenOption[0]));){
            stream.write(fsPatch);
        }
        this.logPrinter.print("Patch created at " + patchFileLocation, EMsgType.PASS);
    }

    private byte[] getPatch1(int offset) throws Exception {
        int requiredInstructionOffsetInternal = offset - 4;
        int requiredInstructionOffsetReal = requiredInstructionOffsetInternal + 256;
        int patch = 522191829;
        this.logPrinter.print(BinToAsmPrinter.printSimplified(Integer.reverseBytes(522191829), requiredInstructionOffsetInternal), EMsgType.NULL);
        ByteBuffer prePatch = ByteBuffer.allocate(10).order(ByteOrder.BIG_ENDIAN).putInt(requiredInstructionOffsetReal).putShort((short)4).putInt(522191829);
        return Arrays.copyOfRange(prePatch.array(), 1, 10);
    }

    private byte[] getPatch2(int offset) throws Exception {
        int requiredInstructionOffsetInternal = offset - 4;
        int requiredInstructionOffsetReal = requiredInstructionOffsetInternal + 256;
        int patch = -536666326;
        this.logPrinter.print(BinToAsmPrinter.printSimplified(Integer.reverseBytes(-536666326), requiredInstructionOffsetInternal), EMsgType.NULL);
        ByteBuffer prePatch = ByteBuffer.allocate(10).order(ByteOrder.BIG_ENDIAN).putInt(requiredInstructionOffsetReal).putShort((short)4).putInt(-536666326);
        return Arrays.copyOfRange(prePatch.array(), 1, 10);
    }
}

