/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.es.finders;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nsusbloader.Utilities.patches.AHeuristic;
import nsusbloader.Utilities.patches.es.finders.HeuristicEs1;
import nsusbloader.Utilities.patches.es.finders.HeuristicEs2;
import nsusbloader.Utilities.patches.es.finders.HeuristicEs3;

public class HeuristicEsWizard {
    private final List<AHeuristic> all;
    private final List<AHeuristic> found;
    private final List<AHeuristic> wantLessEntropy;
    private final StringBuilder errorsAndNotes = new StringBuilder();
    private int offset1 = -1;
    private int offset2 = -1;
    private int offset3 = -1;

    public HeuristicEsWizard(long fwVersion, byte[] where) throws Exception {
        this.all = Arrays.asList(new HeuristicEs1(where), new HeuristicEs2(where), new HeuristicEs3(fwVersion, where));
        this.found = this.all.stream().filter(AHeuristic::isFound).collect(Collectors.toList());
        if (this.found.isEmpty()) {
            throw new Exception("Nothing found!");
        }
        this.wantLessEntropy = this.all.stream().filter(AHeuristic::wantLessEntropy).collect(Collectors.toList());
        this.shareOffsetsWithEachOther();
        this.assignOffset1();
        this.assignOffset2();
        this.assignOffset3();
    }

    private void shareOffsetsWithEachOther() {
        for (AHeuristic es : this.wantLessEntropy) {
            if (!this.shareWithNext(es)) continue;
            return;
        }
    }

    private boolean shareWithNext(AHeuristic es) {
        try {
            for (AHeuristic foundEs : this.found) {
                if (!es.setOffsetsNearby(foundEs.getOffset())) continue;
                this.found.add(es);
                this.wantLessEntropy.remove(es);
                this.shareOffsetsWithEachOther();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void assignOffset1() {
        try {
            this.offset1 = this.all.get(0).getOffset();
        }
        catch (Exception e) {
            this.errorsAndNotes.append(e.getLocalizedMessage()).append("\n");
        }
    }

    private void assignOffset2() {
        try {
            this.offset2 = this.all.get(1).getOffset();
        }
        catch (Exception e) {
            this.errorsAndNotes.append(e.getLocalizedMessage()).append("\n");
        }
    }

    private void assignOffset3() {
        try {
            this.offset3 = this.all.get(2).getOffset();
        }
        catch (Exception e) {
            this.errorsAndNotes.append(e.getLocalizedMessage()).append("\n");
        }
    }

    public String getErrorsAndNotes() {
        return this.errorsAndNotes.toString();
    }

    public String getDebug() {
        StringBuilder builder = new StringBuilder();
        if (this.all.get(0).isFound()) {
            builder.append("\t\t-=== 1 ===-\n");
            builder.append(this.all.get(0).getDetails());
        }
        if (this.all.get(1).isFound()) {
            builder.append("\t\t-=== 2 ===-\n");
            builder.append(this.all.get(1).getDetails());
        }
        if (this.all.get(2).isFound()) {
            builder.append("\t\t-=== 3 ===-\n");
            builder.append(this.all.get(2).getDetails());
        }
        return builder.toString();
    }

    public int getOffset1() {
        return this.offset1;
    }

    public int getOffset2() {
        return this.offset2;
    }

    public int getOffset3() {
        return this.offset3;
    }
}

