/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.ModelControllers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.concurrent.Task;
import javax.net.ssl.HttpsURLConnection;
import nsusbloader.NSLMain;

public class UpdatesChecker
extends Task<List<String>> {
    @Override
    protected List<String> call() {
        String respondedJson;
        try {
            URL gitHubUrl = new URL("https://api.github.com/repos/developersu/ns-usbloader/releases/latest");
            HttpsURLConnection connection = (HttpsURLConnection)gitHubUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int status = connection.getResponseCode();
            if (status != 200) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            respondedJson = br.readLine();
            br.close();
            connection.disconnect();
            if (respondedJson == null) {
                return null;
            }
        }
        catch (IOException mue) {
            return null;
        }
        String newVersion = respondedJson.replaceAll("(^.*\"tag_name\":\")(.?|.+?)(\".+$)", "$2");
        String changeLog = respondedJson.replaceAll("(^.*\"body\":\")(.?|.+?)(\".+$)", "$2").replaceAll("\\\\r\\\\n", "\n").replaceAll("#+?\\s", "");
        if (newVersion.matches("^v(([0-9])+?\\.)+[0-9]+(-.+)$")) {
            newVersion = newVersion.replaceAll("(-.*$)", "");
        }
        if (!newVersion.matches("^v(([0-9])+?\\.)+[0-9]+$")) {
            return null;
        }
        String currentVersion = NSLMain.appVersion.matches("^v(([0-9])+?\\.)+[0-9]+(-.+)$") ? NSLMain.appVersion.replaceAll("(-.*$)", "") : NSLMain.appVersion;
        ArrayList<String> returningValue = new ArrayList<String>();
        if (!newVersion.equals(currentVersion)) {
            returningValue.add(newVersion);
            returningValue.add(changeLog);
            return returningValue;
        }
        returningValue.add("");
        returningValue.add("");
        return returningValue;
    }
}

