/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.File;
import nsusbloader.NSLDataTypes.EFileStatus;

public class NSLRowModel {
    private String status;
    private File nspFile;
    private String nspFileName;
    private long nspFileSize;
    private boolean markForUpload;

    NSLRowModel(File nspFile, boolean checkBoxValue) {
        this.nspFile = nspFile;
        this.markForUpload = checkBoxValue;
        this.nspFileName = nspFile.getName();
        if (nspFile.isFile()) {
            this.nspFileSize = nspFile.length();
        } else {
            File[] subFilesArr = nspFile.listFiles((file, name) -> name.matches("[0-9]{2}"));
            if (subFilesArr != null) {
                for (File subFile : subFilesArr) {
                    this.nspFileSize += subFile.length();
                }
            }
        }
        this.status = "";
    }

    public String getStatus() {
        return this.status;
    }

    public String getNspFileName() {
        return this.nspFileName;
    }

    public long getNspFileSize() {
        return this.nspFileSize;
    }

    public boolean isMarkForUpload() {
        return this.markForUpload;
    }

    public void setMarkForUpload(boolean value) {
        this.markForUpload = value;
    }

    public File getNspFile() {
        return this.nspFile;
    }

    public void setStatus(EFileStatus status) {
        switch (status) {
            case UPLOADED: {
                this.status = "Success";
                this.markForUpload = false;
                break;
            }
            case FAILED: {
                this.status = "Failed";
                break;
            }
            case INDETERMINATE: {
                this.status = "...";
                break;
            }
            case UNKNOWN: {
                this.status = "Unknown";
                break;
            }
            case INCORRECT_FILE_FAILED: {
                this.status = "Failed: Bad file";
                this.markForUpload = false;
            }
        }
    }
}

