/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import nsusbloader.AppPreferences;
import nsusbloader.Controllers.FilesDropHandle;
import nsusbloader.Controllers.ISubscriber;
import nsusbloader.Controllers.NSTableViewController;
import nsusbloader.Controllers.Payload;
import nsusbloader.Controllers.SettingsBlockGoldleafController;
import nsusbloader.Controllers.SettingsBlockTinfoilController;
import nsusbloader.Controllers.SettingsController;
import nsusbloader.FilesHelper;
import nsusbloader.MediatorControl;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.NSLDataTypes.EFileStatus;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.ServiceWindow;
import nsusbloader.com.net.NETCommunications;
import nsusbloader.com.usb.UsbCommunications;

public class GamesController
implements Initializable,
ISubscriber {
    private static final String REGEX_ONLY_NSP = ".*\\.nsp$";
    private static final String REGEX_ALLFILES_TINFOIL = ".*\\.(nsp$|xci$|nsz$|xcz$)";
    private static final String REGEX_ALLFILES = ".*";
    private static final MediatorControl mediator = MediatorControl.INSTANCE;
    @FXML
    private AnchorPane usbNetPane;
    @FXML
    private ChoiceBox<String> choiceProtocol;
    @FXML
    private ChoiceBox<String> choiceNetUsb;
    @FXML
    private Label nsIpLbl;
    @FXML
    private TextField nsIpTextField;
    @FXML
    private Button switchThemeBtn;
    @FXML
    private NSTableViewController tableFilesListController;
    @FXML
    private Button selectNspBtn;
    @FXML
    private Button selectSplitBtn;
    @FXML
    private Button uploadStopBtn;
    private String previouslyOpenedPath;
    private Region btnUpStopImage;
    private Region btnSelectImage;
    private ResourceBundle resourceBundle;
    private CancellableRunnable usbNetCommunications;
    private Thread workThread;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        AppPreferences preferences = AppPreferences.getInstance();
        ObservableList<String> choiceProtocolList = FXCollections.observableArrayList("Awoo", "GoldLeaf");
        this.choiceProtocol.setItems(choiceProtocolList);
        this.choiceProtocol.getSelectionModel().select(preferences.getProtocol());
        this.choiceProtocol.setOnAction(e -> {
            this.tableFilesListController.setNewProtocol(this.getSelectedProtocolByName());
            if (this.isGoldLeaf()) {
                this.choiceNetUsb.setDisable(true);
                this.choiceNetUsb.getSelectionModel().select("USB");
                this.nsIpLbl.setVisible(false);
                this.nsIpTextField.setVisible(false);
            } else {
                this.choiceNetUsb.setDisable(false);
                if (this.getSelectedNetUsb().equals("NET")) {
                    this.nsIpLbl.setVisible(true);
                    this.nsIpTextField.setVisible(true);
                }
            }
            this.disableUploadStopBtn(this.tableFilesListController.isFilesForUploadListEmpty());
        });
        this.tableFilesListController.setNewProtocol(this.getSelectedProtocolByName());
        this.tableFilesListController.setGamesController(this);
        ObservableList<String> choiceNetUsbList = FXCollections.observableArrayList("USB", "NET");
        this.choiceNetUsb.setItems(choiceNetUsbList);
        this.choiceNetUsb.getSelectionModel().select(preferences.getNetUsb());
        if (this.isGoldLeaf()) {
            this.choiceNetUsb.setDisable(true);
            this.choiceNetUsb.getSelectionModel().select("USB");
        }
        this.choiceNetUsb.setOnAction(e -> {
            if (this.getSelectedNetUsb().equals("NET")) {
                this.nsIpLbl.setVisible(true);
                this.nsIpTextField.setVisible(true);
            } else {
                this.nsIpLbl.setVisible(false);
                this.nsIpTextField.setVisible(false);
            }
        });
        this.nsIpTextField.setText(preferences.getNsIp());
        if (this.isTinfoil() && this.getSelectedNetUsb().equals("NET")) {
            this.nsIpLbl.setVisible(true);
            this.nsIpTextField.setVisible(true);
        }
        this.nsIpTextField.setTextFormatter(new TextFormatter(change -> {
            if (change.getControlNewText().contains(" ") | change.getControlNewText().contains("\t")) {
                return null;
            }
            return change;
        }));
        Region btnSwitchImage = new Region();
        btnSwitchImage.getStyleClass().add("regionLamp");
        this.switchThemeBtn.setGraphic(btnSwitchImage);
        this.switchThemeBtn.setOnAction(e -> this.switchTheme());
        this.selectNspBtn.getStyleClass().add("buttonSelect");
        this.btnSelectImage = new Region();
        this.setFilesSelectorButtonBehaviour(preferences.getDirectoriesChooserForRoms());
        this.selectSplitBtn.setOnAction(e -> this.selectSplitBtnAction());
        this.selectSplitBtn.getStyleClass().add("buttonSelect");
        this.uploadStopBtn.setOnAction(e -> this.uploadBtnAction());
        this.uploadStopBtn.setDisable(this.isTinfoil());
        this.btnUpStopImage = new Region();
        this.btnUpStopImage.getStyleClass().add("regionUpload");
        this.uploadStopBtn.getStyleClass().add("buttonUp");
        this.uploadStopBtn.setGraphic(this.btnUpStopImage);
        this.previouslyOpenedPath = preferences.getRecent();
    }

    private void switchTheme() {
        String darkTheme = "/res/app_dark.css";
        String lightTheme = "/res/app_light.css";
        ObservableList<String> styleSheets = this.switchThemeBtn.getScene().getStylesheets();
        if (((String)styleSheets.get(0)).equals("/res/app_dark.css")) {
            styleSheets.remove("/res/app_dark.css");
            styleSheets.add("/res/app_light.css");
        } else {
            styleSheets.remove("/res/app_light.css");
            styleSheets.add("/res/app_dark.css");
        }
        AppPreferences.getInstance().setTheme((String)styleSheets.get(0));
    }

    private int getSelectedProtocolByIndex() {
        return this.choiceProtocol.getSelectionModel().getSelectedIndex();
    }

    private String getSelectedProtocolByName() {
        return (String)this.choiceProtocol.getSelectionModel().getSelectedItem();
    }

    private String getSelectedNetUsb() {
        return (String)this.choiceNetUsb.getSelectionModel().getSelectedItem();
    }

    private String getNsIp() {
        return this.nsIpTextField.getText();
    }

    private boolean isGoldLeaf() {
        return this.getSelectedProtocolByName().equals("GoldLeaf");
    }

    private boolean isTinfoil() {
        return this.getSelectedProtocolByName().equals("Awoo");
    }

    private boolean isAllFiletypesAllowedForGL() {
        return !mediator.getSettingsController().getGoldleafSettings().getNSPFileFilterForGL();
    }

    private boolean isXciNszXczSupport() {
        return mediator.getSettingsController().getTinfoilSettings().isXciNszXczSupport();
    }

    private String getRegexForFiles() {
        if (this.isTinfoil() && this.isXciNszXczSupport()) {
            return REGEX_ALLFILES_TINFOIL;
        }
        if (this.isGoldLeaf() && this.isAllFiletypesAllowedForGL()) {
            return REGEX_ALLFILES;
        }
        return REGEX_ONLY_NSP;
    }

    private String getRegexForFolders() {
        String regexForFiles = this.getRegexForFiles();
        if (regexForFiles.equals(REGEX_ALLFILES)) {
            return REGEX_ALLFILES_TINFOIL;
        }
        return regexForFiles;
    }

    private void selectFilesBtnAction() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle.getString("btn_OpenFile"));
        fileChooser.setInitialDirectory(new File(FilesHelper.getRealFolder(this.previouslyOpenedPath)));
        if (this.isTinfoil() && this.isXciNszXczSupport()) {
            fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("NSP/XCI/NSZ/XCZ", "*.nsp", "*.xci", "*.nsz", "*.xcz"));
        } else if (this.isGoldLeaf() && this.isAllFiletypesAllowedForGL()) {
            fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Any file", "*.*"), new FileChooser.ExtensionFilter("NSP ROM", "*.nsp")});
        } else {
            fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("NSP ROM", "*.nsp"));
        }
        List<File> filesList = fileChooser.showOpenMultipleDialog(this.usbNetPane.getScene().getWindow());
        if (filesList != null && !filesList.isEmpty()) {
            this.tableFilesListController.setFiles(filesList);
            this.uploadStopBtn.setDisable(false);
            this.previouslyOpenedPath = filesList.get(0).getParent();
        }
    }

    private void selectFoldersBtnAction() {
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setTitle(this.resourceBundle.getString("btn_OpenFolders"));
        chooser.setInitialDirectory(new File(FilesHelper.getRealFolder(this.previouslyOpenedPath)));
        File startFolder = chooser.showDialog(this.usbNetPane.getScene().getWindow());
        this.performInBackgroundAndUpdate(() -> {
            ArrayList<File> allFiles = new ArrayList<File>();
            this.collectFiles(allFiles, startFolder, this.getRegexForFiles(), this.getRegexForFolders());
            return allFiles;
        }, files -> {
            if (!files.isEmpty()) {
                this.tableFilesListController.setFiles((List<File>)files);
                this.uploadStopBtn.setDisable(false);
                this.previouslyOpenedPath = startFolder.getParent();
            }
        });
    }

    private void collectFiles(List<File> storage, File startFolder, String filesRegex, String foldersRegex) {
        if (startFolder == null) {
            return;
        }
        String startFolderNameInLowercase = startFolder.getName().toLowerCase();
        if (startFolder.isFile()) {
            if (startFolderNameInLowercase.matches(filesRegex)) {
                storage.add(startFolder);
            }
            return;
        }
        if (startFolderNameInLowercase.matches(foldersRegex)) {
            storage.add(startFolder);
            return;
        }
        File[] files = startFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.collectFiles(storage, file, filesRegex, foldersRegex);
        }
    }

    private void selectSplitBtnAction() {
        DirectoryChooser dirChooser = new DirectoryChooser();
        dirChooser.setTitle(this.resourceBundle.getString("btn_OpenFile"));
        String saveToLocation = FilesHelper.getRealFolder(this.previouslyOpenedPath);
        dirChooser.setInitialDirectory(new File(saveToLocation));
        File splitFile = dirChooser.showDialog(this.usbNetPane.getScene().getWindow());
        if (splitFile == null) {
            return;
        }
        int fileNameLen = splitFile.getName().length();
        String fileExtension = splitFile.getName().toLowerCase().substring(fileNameLen - 4, fileNameLen);
        if (fileExtension.equals(".nsp")) {
            this.tableFilesListController.setFile(splitFile);
            this.uploadStopBtn.setDisable(false);
            this.previouslyOpenedPath = splitFile.getParent();
        }
        if (this.isTinfoil() && this.isXciNszXczSupport()) {
            switch (fileExtension) {
                case ".xci": 
                case ".nsz": 
                case ".xcz": {
                    this.tableFilesListController.setFile(splitFile);
                    this.uploadStopBtn.setDisable(false);
                    this.previouslyOpenedPath = splitFile.getParent();
                }
            }
        }
    }

    private void uploadBtnAction() {
        if (this.workThread != null && this.workThread.isAlive()) {
            return;
        }
        if (this.isTinfoil() && this.tableFilesListController.getFilesForUpload() == null) {
            ServiceWindow.getInfoNotification("(o_o\")", this.resourceBundle.getString("tab3_Txt_NoFolderOrFileSelected"));
            return;
        }
        List<File> nspToUpload = this.tableFilesListController.getFilesForUpload();
        if (nspToUpload == null) {
            nspToUpload = new ArrayList<File>();
        }
        SettingsController settings = mediator.getSettingsController();
        if (this.isGoldLeaf()) {
            SettingsBlockGoldleafController goldleafSettings = settings.getGoldleafSettings();
            this.usbNetCommunications = new UsbCommunications(nspToUpload, "GoldLeaf" + goldleafSettings.getGlVer(), goldleafSettings.getNSPFileFilterForGL());
        } else if (this.getSelectedNetUsb().equals("USB")) {
            this.usbNetCommunications = new UsbCommunications(nspToUpload, "TinFoil", false);
        } else {
            String ipValidationPattern = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
            SettingsBlockTinfoilController tinfoilSettings = settings.getTinfoilSettings();
            if (tinfoilSettings.isValidateNSHostName() && !this.getNsIp().matches("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$") && !ServiceWindow.getConfirmationWindow(this.resourceBundle.getString("windowTitleBadIp"), this.resourceBundle.getString("windowBodyBadIp"))) {
                return;
            }
            String nsIP = this.getNsIp();
            this.usbNetCommunications = !tinfoilSettings.isExpertModeSelected() ? new NETCommunications(nspToUpload, nsIP, false, "", "", "") : new NETCommunications(nspToUpload, nsIP, tinfoilSettings.isNoRequestsServe(), tinfoilSettings.isAutoDetectIp() ? "" : tinfoilSettings.getHostIp(), tinfoilSettings.isRandomlySelectPort() ? "" : tinfoilSettings.getHostPort(), tinfoilSettings.isNoRequestsServe() ? tinfoilSettings.getHostExtra() : "");
        }
        this.workThread = new Thread(this.usbNetCommunications);
        this.workThread.setDaemon(true);
        this.workThread.start();
    }

    private void stopBtnAction() {
        if (this.workThread == null || !this.workThread.isAlive()) {
            return;
        }
        this.usbNetCommunications.cancel();
        if (this.usbNetCommunications instanceof NETCommunications) {
            try {
                ((NETCommunications)this.usbNetCommunications).getServerSocket().close();
                ((NETCommunications)this.usbNetCommunications).getClientSocket().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @FXML
    private void handleDragOver(DragEvent event) {
        if (event.getDragboard().hasFiles() && !mediator.getTransferActive()) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    @FXML
    private void handleDrop(DragEvent event) {
        List<File> files = event.getDragboard().getFiles();
        new FilesDropHandle(files, this.getRegexForFiles(), this.getRegexForFolders(), this.tableFilesListController);
        event.setDropCompleted(true);
        event.consume();
    }

    void disableUploadStopBtn(boolean disable) {
        if (this.isTinfoil()) {
            this.uploadStopBtn.setDisable(disable);
        } else {
            this.uploadStopBtn.setDisable(false);
        }
    }

    private <T> void performInBackgroundAndUpdate(Supplier<T> background, Consumer<T> update) {
        new Thread(() -> {
            Object result = background.get();
            Platform.runLater(() -> update.accept(result));
        }).start();
    }

    void setFilesSelectorButtonBehaviour(boolean isDirectoryChooser) {
        this.btnSelectImage.getStyleClass().clear();
        if (isDirectoryChooser) {
            this.selectNspBtn.setOnAction(e -> this.selectFoldersBtnAction());
            this.btnSelectImage.getStyleClass().add("regionScanFolders");
            this.selectSplitBtn.setVisible(false);
        } else {
            this.selectNspBtn.setOnAction(e -> this.selectFilesBtnAction());
            this.btnSelectImage.getStyleClass().add("regionSelectFiles");
            this.selectSplitBtn.setVisible(true);
        }
        this.selectNspBtn.setGraphic(this.btnSelectImage);
    }

    private String getRecentPath() {
        return this.previouslyOpenedPath;
    }

    public void updatePreferencesOnExit() {
        AppPreferences preferences = AppPreferences.getInstance();
        preferences.setProtocol(this.getSelectedProtocolByIndex());
        preferences.setRecent(this.getRecentPath());
        preferences.setNetUsb(this.getSelectedNetUsb());
        preferences.setNsIp(this.getNsIp());
    }

    @Override
    public void notify(EModule type, boolean isActive, Payload payload) {
        if (!type.equals((Object)EModule.USB_NET_TRANSFERS)) {
            this.usbNetPane.setDisable(isActive);
            return;
        }
        this.selectNspBtn.setDisable(isActive);
        this.selectSplitBtn.setDisable(isActive);
        this.btnUpStopImage.getStyleClass().clear();
        if (isActive) {
            this.btnUpStopImage.getStyleClass().add("regionStop");
            this.uploadStopBtn.setOnAction(e -> this.stopBtnAction());
            this.uploadStopBtn.setText(this.resourceBundle.getString("btn_Stop"));
            this.uploadStopBtn.getStyleClass().remove("buttonUp");
            this.uploadStopBtn.getStyleClass().add("buttonStop");
            return;
        }
        this.btnUpStopImage.getStyleClass().add("regionUpload");
        this.uploadStopBtn.setOnAction(e -> this.uploadBtnAction());
        this.uploadStopBtn.setText(this.resourceBundle.getString("btn_Upload"));
        this.uploadStopBtn.getStyleClass().remove("buttonStop");
        this.uploadStopBtn.getStyleClass().add("buttonUp");
        Map<String, EFileStatus> statusMap = payload.getStatusMap();
        if (!statusMap.isEmpty()) {
            for (String key : statusMap.keySet()) {
                this.tableFilesListController.setFileStatus(key, statusMap.get(key));
            }
        }
    }
}

