/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.other.System2;

import libKonogonka.Converter;
import libKonogonka.RainbowDump;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KernelMap {
    private static final Logger log = LogManager.getLogger(KernelMap.class);
    private final int textStartOffset;
    private final int textEndOffset;
    private final int rodataStartOffset;
    private final int rodataEndOffset;
    private final int dataStartOffset;
    private final int dataEndOffset;
    private final int bssStartOffset;
    private final int bssEndOffset;
    private final int ini1Offset;
    private final int dynamicOffset;
    private final int initArrayStartOffset;
    private final int initArrayEndOffset;

    public KernelMap(byte[] mapBytes, int offset) {
        this.textStartOffset = Converter.getLEint(mapBytes, offset);
        this.textEndOffset = Converter.getLEint(mapBytes, offset + 4);
        this.rodataStartOffset = Converter.getLEint(mapBytes, offset + 8);
        this.rodataEndOffset = Converter.getLEint(mapBytes, offset + 12);
        this.dataStartOffset = Converter.getLEint(mapBytes, offset + 16);
        this.dataEndOffset = Converter.getLEint(mapBytes, offset + 20);
        this.bssStartOffset = Converter.getLEint(mapBytes, offset + 24);
        this.bssEndOffset = Converter.getLEint(mapBytes, offset + 28);
        this.ini1Offset = Converter.getLEint(mapBytes, offset + 32);
        this.dynamicOffset = Converter.getLEint(mapBytes, offset + 36);
        this.initArrayStartOffset = Converter.getLEint(mapBytes, offset + 40);
        this.initArrayEndOffset = Converter.getLEint(mapBytes, offset + 44);
    }

    public int getTextStartOffset() {
        return this.textStartOffset;
    }

    public int getTextEndOffset() {
        return this.textEndOffset;
    }

    public int getRodataStartOffset() {
        return this.rodataStartOffset;
    }

    public int getRodataEndOffset() {
        return this.rodataEndOffset;
    }

    public int getDataStartOffset() {
        return this.dataStartOffset;
    }

    public int getDataEndOffset() {
        return this.dataEndOffset;
    }

    public int getBssStartOffset() {
        return this.bssStartOffset;
    }

    public int getBssEndOffset() {
        return this.bssEndOffset;
    }

    public int getIni1Offset() {
        return this.ini1Offset;
    }

    public int getDynamicOffset() {
        return this.dynamicOffset;
    }

    public int getInitArrayStartOffset() {
        return this.initArrayStartOffset;
    }

    public int getInitArrayEndOffset() {
        return this.initArrayEndOffset;
    }

    public boolean isValid(long maxSize) {
        if (this.textStartOffset != 0) {
            return false;
        }
        if (this.textStartOffset >= this.textEndOffset) {
            return false;
        }
        if ((this.textEndOffset & 0xFFF) > 0) {
            return false;
        }
        if (this.textEndOffset > this.rodataStartOffset) {
            return false;
        }
        if ((this.rodataStartOffset & 0xFFF) > 0) {
            return false;
        }
        if (this.rodataStartOffset >= this.rodataEndOffset) {
            return false;
        }
        if ((this.rodataEndOffset & 0xFFF) > 0) {
            return false;
        }
        if (this.rodataEndOffset > this.dataStartOffset) {
            return false;
        }
        if ((this.dataStartOffset & 0xFFF) > 0) {
            return false;
        }
        if (this.dataStartOffset >= this.dataEndOffset) {
            return false;
        }
        if (this.dataEndOffset > this.bssStartOffset) {
            return false;
        }
        if (this.bssStartOffset > this.bssEndOffset) {
            return false;
        }
        if (this.bssEndOffset > this.ini1Offset) {
            return false;
        }
        return (long)this.ini1Offset <= maxSize - 128L;
    }

    public void printDebug() {
        log.debug("_ Kernel map _\n  .text Start Offset            " + RainbowDump.formatDecHexString(this.textStartOffset) + "\n  .text End Offset              " + RainbowDump.formatDecHexString(this.textEndOffset) + "\n  .rodata Start Offset          " + RainbowDump.formatDecHexString(this.rodataStartOffset) + "\n  .rodata End Offset            " + RainbowDump.formatDecHexString(this.rodataEndOffset) + "\n  .data Start Offset            " + RainbowDump.formatDecHexString(this.dataStartOffset) + "\n  .data End Offset              " + RainbowDump.formatDecHexString(this.dataEndOffset) + "\n  .bss Start Offset             " + RainbowDump.formatDecHexString(this.bssStartOffset) + "\n  .bss End Offset               " + RainbowDump.formatDecHexString(this.bssEndOffset) + "\n  INI1 Offset                   " + RainbowDump.formatDecHexString(this.ini1Offset) + "\n  Dynamic Offset                " + RainbowDump.formatDecHexString(this.dynamicOffset) + "\n  Init array Start Offset       " + RainbowDump.formatDecHexString(this.initArrayStartOffset) + "\n  Init array End Offset         " + RainbowDump.formatDecHexString(this.initArrayEndOffset));
    }
}

