/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.XCI;

import java.util.Arrays;
import libKonogonka.Converter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XCIGamecardCert {
    private static final Logger log = LogManager.getLogger(XCIGamecardCert.class);
    private final byte[] rsa2048PKCS1sig;
    private final byte[] magicCert;
    private final byte[] unknown1;
    private final byte kekIndex;
    private final byte[] unknown2;
    private final byte[] deviceID;
    private final byte[] unknown3;
    private final byte[] encryptedData;

    XCIGamecardCert(byte[] certBytes) throws Exception {
        if (certBytes.length != 512) {
            throw new Exception("XCIGamecardCert Incorrect array size. Expected 512 bytes while received " + certBytes.length);
        }
        this.rsa2048PKCS1sig = Arrays.copyOfRange(certBytes, 0, 256);
        this.magicCert = Arrays.copyOfRange(certBytes, 256, 260);
        this.unknown1 = Arrays.copyOfRange(certBytes, 260, 264);
        this.kekIndex = certBytes[264];
        this.unknown2 = Arrays.copyOfRange(certBytes, 265, 272);
        this.deviceID = Arrays.copyOfRange(certBytes, 272, 288);
        this.unknown3 = Arrays.copyOfRange(certBytes, 288, 298);
        this.encryptedData = Arrays.copyOfRange(certBytes, 298, 512);
    }

    public byte[] getRsa2048PKCS1sig() {
        return this.rsa2048PKCS1sig;
    }

    public byte[] getMagicCert() {
        return this.magicCert;
    }

    public boolean isMagicCertOk() {
        return Arrays.equals(this.magicCert, new byte[]{72, 69, 65, 68});
    }

    public byte[] getUnknown1() {
        return this.unknown1;
    }

    public byte getKekIndex() {
        return this.kekIndex;
    }

    public byte[] getUnknown2() {
        return this.unknown2;
    }

    public byte[] getDeviceID() {
        return this.deviceID;
    }

    public byte[] getUnknown3() {
        return this.unknown3;
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public void printDebug() {
        log.debug("== XCIGamecardCert ==\nrsa2048PKCS1sig  " + Converter.byteArrToHexStringAsLE(this.rsa2048PKCS1sig) + "\nmagicCert        " + Converter.byteArrToHexStringAsLE(this.magicCert) + "\nunknown1         " + Converter.byteArrToHexStringAsLE(this.unknown1) + "\nkekIndex         " + this.kekIndex + "\nunknown2         " + Converter.byteArrToHexStringAsLE(this.unknown2) + "\ndeviceID         " + Converter.byteArrToHexStringAsLE(this.deviceID) + "\nunknown3         " + Converter.byteArrToHexStringAsLE(this.unknown3) + "\nencryptedData    " + Converter.byteArrToHexStringAsLE(this.encryptedData) + "\n");
    }
}

