/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.RomFs.view;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.RainbowDump;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryMetaTablePlainView {
    private static final Logger log = LogManager.getLogger(DirectoryMetaTablePlainView.class);

    public DirectoryMetaTablePlainView(long directoryMetadataTableLength, byte[] directoryMetadataTable) {
        int i = 0;
        while ((long)i < directoryMetadataTableLength) {
            FolderMeta folderMeta = new FolderMeta();
            folderMeta.parentDirectoryOffset = Converter.getLEint(directoryMetadataTable, i);
            folderMeta.nextSiblingDirectoryOffset = Converter.getLEint(directoryMetadataTable, i += 4);
            folderMeta.firstSubdirectoryOffset = Converter.getLEint(directoryMetadataTable, i += 4);
            folderMeta.firstFileOffset = Converter.getLEint(directoryMetadataTable, i += 4);
            folderMeta.nextDirectoryOffset = Converter.getLEint(directoryMetadataTable, i += 4);
            folderMeta.dirNameLength = Converter.getLEint(directoryMetadataTable, i += 4);
            folderMeta.dirName = new String(Arrays.copyOfRange(directoryMetadataTable, i += 4, i + folderMeta.dirNameLength), StandardCharsets.UTF_8);
            i += this.getRealNameSize(folderMeta.dirNameLength);
            log.debug("- DIRECTORY -\nOffset of Parent Directory (self if Root)              " + RainbowDump.formatDecHexString(folderMeta.parentDirectoryOffset) + "\nOffset of next Sibling Directory                       " + RainbowDump.formatDecHexString(folderMeta.nextSiblingDirectoryOffset) + "\nOffset of first Child Directory (Subdirectory)         " + RainbowDump.formatDecHexString(folderMeta.firstSubdirectoryOffset) + "\nOffset of first File (in File Metadata Table)          " + RainbowDump.formatDecHexString(folderMeta.firstFileOffset) + "\nOffset of next Directory in the same Hash Table bucket " + RainbowDump.formatDecHexString(folderMeta.nextDirectoryOffset) + "\nName Length                                            " + RainbowDump.formatDecHexString(folderMeta.dirNameLength) + "\nName Length (rounded up to multiple of 4)              " + folderMeta.dirName + "\n");
        }
    }

    private int getRealNameSize(int value) {
        if (value % 4 == 0) {
            return value;
        }
        return value + 4 - value % 4;
    }

    private static class FolderMeta {
        int parentDirectoryOffset;
        int nextSiblingDirectoryOffset;
        int firstSubdirectoryOffset;
        int firstFileOffset;
        int nextDirectoryOffset;
        int dirNameLength;
        String dirName;

        private FolderMeta() {
        }
    }
}

