/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NSO;

import java.io.BufferedInputStream;
import java.io.File;
import libKonogonka.aesctr.InFileStreamProducer;
import libKonogonka.fs.NSO.NSO0Header;
import libKonogonka.fs.NSO.NSO0Raw;
import libKonogonka.fs.NSO.NSO0Unpacker;

public class NSO0Provider {
    private final InFileStreamProducer producer;
    private final NSO0Header header;

    public NSO0Provider(InFileStreamProducer producer) throws Exception {
        this.producer = producer;
        try (BufferedInputStream stream = producer.produce();){
            byte[] knownStartingBytes = new byte[256];
            if (256 != stream.read(knownStartingBytes)) {
                throw new Exception("Reading stream suddenly ended while trying to read starting 0x100 bytes");
            }
            this.header = new NSO0Header(knownStartingBytes);
        }
    }

    public NSO0Provider(File file) throws Exception {
        this(file, 0L);
    }

    public NSO0Provider(File file, long offsetPosition) throws Exception {
        this.producer = new InFileStreamProducer(file, offsetPosition);
        try (BufferedInputStream stream = this.producer.produce();){
            if (offsetPosition != stream.skip(offsetPosition)) {
                throw new Exception("Can't skip bytes prior NSO0 offset");
            }
            byte[] knownStartingBytes = new byte[256];
            if (256 != stream.read(knownStartingBytes)) {
                throw new Exception("Reading stream suddenly ended while trying to read starting 0x100 bytes");
            }
            this.header = new NSO0Header(knownStartingBytes);
        }
    }

    public NSO0Header getHeader() {
        return this.header;
    }

    public void exportAsDecompressedNSO0(String saveToLocation) throws Exception {
        NSO0Unpacker.unpack(this.header, this.producer, saveToLocation);
    }

    public NSO0Raw getAsDecompressedNSO0() throws Exception {
        return NSO0Unpacker.getNSO0Raw(this.header, this.producer);
    }

    public void printDebug() {
        this.header.printDebug();
    }
}

