/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NPDM;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import libKonogonka.Converter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KernelAccessControlProvider {
    private static final Logger log = LogManager.getLogger(KernelAccessControlProvider.class);
    private static final int KERNELFLAGS = 3;
    private static final int SYSCALLMASK = 4;
    private static final int MAPIOORNORMALRANGE = 6;
    private static final int MAPNORMALPAGE_RW = 7;
    private static final int INTERRUPTPAIR = 11;
    private static final int APPLICATIONTYPE = 13;
    private static final int KERNELRELEASEVERSION = 14;
    private static final int HANDLETABLESIZE = 15;
    private static final int DEBUGFLAGS = 16;
    private final LinkedList<Integer> rawData;
    private final byte[] raw;
    private boolean kernelFlagsAvailable;
    private int kernelFlagCpuIdHi;
    private int kernelFlagCpuIdLo;
    private int kernelFlagThreadPrioHi;
    private int kernelFlagThreadPrioLo;
    private final LinkedHashMap<Byte, byte[]> syscallMasks;
    private final LinkedHashMap<byte[], Boolean> mapIoOrNormalRange;
    private byte[] mapNormalPage;
    private final LinkedHashMap<Integer, byte[][]> interruptPairs;
    private int applicationType;
    private boolean isKernelRelVersionAvailable;
    private int kernelRelVersionMajor;
    private int kernelRelVersionMinor;
    private int handleTableSize;
    private boolean debugFlagsAvailable;
    private boolean canBeDebugged;
    private boolean canDebugOthers;

    public KernelAccessControlProvider(byte[] bytes) throws Exception {
        if (bytes.length < 4) {
            throw new Exception("ACID-> KernelAccessControlProvider: too small size of the Kernel Access Control");
        }
        this.rawData = new LinkedList();
        this.raw = bytes;
        this.interruptPairs = new LinkedHashMap();
        this.syscallMasks = new LinkedHashMap();
        this.mapIoOrNormalRange = new LinkedHashMap();
        block12: for (int position = 0; position < bytes.length; position += 4) {
            int block = Converter.getLEint(bytes, position);
            this.rawData.add(block);
            int type = this.findBitsCount(block);
            switch (type) {
                case 3: {
                    this.kernelFlagsAvailable = true;
                    this.kernelFlagCpuIdHi = block >> 24;
                    this.kernelFlagCpuIdLo = block >> 16 & 0xFF;
                    this.kernelFlagThreadPrioHi = block >> 10 & 0x3F;
                    this.kernelFlagThreadPrioLo = block >> 4 & 0x3F;
                    log.trace("KERNELFLAGS " + this.kernelFlagCpuIdHi + " " + this.kernelFlagCpuIdLo + " " + this.kernelFlagThreadPrioHi + " " + this.kernelFlagThreadPrioLo);
                    continue block12;
                }
                case 4: {
                    byte maskTableIndex = (byte)(block >> 29 & 7);
                    byte[] mask = new byte[24];
                    log.trace("SYSCALLMASK ind: " + maskTableIndex);
                    for (int k = 28; k >= 5; --k) {
                        mask[k - 5] = (byte)(block >> k & 1);
                        log.trace("[" + (k - 4) + "/24]\t" + mask[k - 5]);
                    }
                    this.syscallMasks.put(maskTableIndex, mask);
                    continue block12;
                }
                case 6: {
                    byte[] altStPgNPgNum = new byte[24];
                    log.trace("MAPIOORNORMALRANGE Flag: " + ((block >> 31 & 1) != 0));
                    for (int k = 30; k >= 7; --k) {
                        altStPgNPgNum[k - 7] = (byte)(block >> k & 1);
                        log.trace("  " + altStPgNPgNum[k - 7]);
                    }
                    this.mapIoOrNormalRange.put(altStPgNPgNum, (block >> 31 & 1) != 0);
                    continue block12;
                }
                case 7: {
                    log.trace("MAPNORMALPAGE_RW\t");
                    this.mapNormalPage = new byte[24];
                    for (int k = 31; k >= 8; --k) {
                        this.mapNormalPage[k - 8] = (byte)(block >> k & 1);
                        log.trace("  " + this.mapNormalPage[k - 8]);
                    }
                    continue block12;
                }
                case 11: {
                    int k;
                    log.trace("INTERRUPTPAIR");
                    byte[][] pair = new byte[2][];
                    byte[] irq0 = new byte[10];
                    byte[] irq1 = new byte[10];
                    for (k = 21; k >= 12; --k) {
                        irq0[k - 12] = (byte)(block >> k & 1);
                    }
                    for (k = 31; k >= 22; --k) {
                        irq1[k - 22] = (byte)(block >> k & 1);
                    }
                    pair[0] = irq0;
                    pair[1] = irq1;
                    this.interruptPairs.put(this.interruptPairs.size(), pair);
                    continue block12;
                }
                case 13: {
                    this.applicationType = block >> 14 & 7;
                    log.trace("APPLICATIONTYPE " + this.applicationType);
                    continue block12;
                }
                case 14: {
                    log.trace("KERNELRELEASEVERSION\t" + (block >> 19 & 0xFFF) + "." + (block >> 15 & 0xF) + ".X");
                    this.isKernelRelVersionAvailable = true;
                    this.kernelRelVersionMajor = block >> 19 & 0xFFF;
                    this.kernelRelVersionMinor = block >> 15 & 0xF;
                    continue block12;
                }
                case 15: {
                    this.handleTableSize = block >> 16 & 0x3FF;
                    log.trace("HANDLETABLESIZE " + this.handleTableSize);
                    continue block12;
                }
                case 16: {
                    this.debugFlagsAvailable = true;
                    this.canBeDebugged = (block >> 17 & 1) != 0;
                    this.canDebugOthers = (block >> 18 & 1) != 0;
                    log.trace("DEBUGFLAGS " + this.canBeDebugged + " " + this.canDebugOthers);
                    continue block12;
                }
                case 32: {
                    continue block12;
                }
                default: {
                    log.warn("INVALID ind:0b" + Integer.toBinaryString(block));
                }
            }
        }
    }

    private int findBitsCount(int value) {
        int minBitCnt = 0;
        for (int i = 0; i < 32 && (value & 1) != 0; ++i) {
            value >>= 1;
            ++minBitCnt;
        }
        return minBitCnt;
    }

    public LinkedList<Integer> getRawData() {
        return this.rawData;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public boolean isKernelFlagsAvailable() {
        return this.kernelFlagsAvailable;
    }

    public int getKernelFlagCpuIdHi() {
        return this.kernelFlagCpuIdHi;
    }

    public int getKernelFlagCpuIdLo() {
        return this.kernelFlagCpuIdLo;
    }

    public int getKernelFlagThreadPrioHi() {
        return this.kernelFlagThreadPrioHi;
    }

    public int getKernelFlagThreadPrioLo() {
        return this.kernelFlagThreadPrioLo;
    }

    public LinkedHashMap<byte[], Boolean> getMapIoOrNormalRange() {
        return this.mapIoOrNormalRange;
    }

    public byte[] getMapNormalPage() {
        return this.mapNormalPage;
    }

    public LinkedHashMap<Integer, byte[][]> getInterruptPairs() {
        return this.interruptPairs;
    }

    public int getApplicationType() {
        return this.applicationType;
    }

    public boolean isKernelRelVersionAvailable() {
        return this.isKernelRelVersionAvailable;
    }

    public int getKernelRelVersionMajor() {
        return this.kernelRelVersionMajor;
    }

    public int getKernelRelVersionMinor() {
        return this.kernelRelVersionMinor;
    }

    public int getHandleTableSize() {
        return this.handleTableSize;
    }

    public boolean isDebugFlagsAvailable() {
        return this.debugFlagsAvailable;
    }

    public boolean isCanBeDebugged() {
        return this.canBeDebugged;
    }

    public boolean isCanDebugOthers() {
        return this.canDebugOthers;
    }

    public LinkedHashMap<Byte, byte[]> getSyscallMasks() {
        return this.syscallMasks;
    }
}

