/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NCA.NCASectionTableBlock;

import java.util.Arrays;
import libKonogonka.Converter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaDataHashDataInfo {
    private static final Logger log = LogManager.getLogger(MetaDataHashDataInfo.class);
    private final long offset;
    private final long size;
    private final byte[] tableHash;

    MetaDataHashDataInfo(byte[] rawTable) {
        this.offset = Converter.getLElong(rawTable, 0);
        this.size = Converter.getLElong(rawTable, 8);
        this.tableHash = Arrays.copyOfRange(rawTable, 16, 32);
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public byte[] getTableHash() {
        return this.tableHash;
    }

    public void printDebug() {
        log.debug("MetaDataHashDataInfo:\nOffset       : " + this.offset + "\nSize         : " + this.size + "\nTable Hash   : " + Converter.byteArrToHexStringAsLE(this.tableHash) + "\n");
    }
}

