/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NCA;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import libKonogonka.Converter;
import libKonogonka.exceptions.EmptySectionException;
import libKonogonka.fs.NCA.NCAContent;
import libKonogonka.fs.NCA.NCAHeaderTableEntry;
import libKonogonka.fs.NCA.NCASectionTableBlock.NcaFsHeader;
import libKonogonka.xtsaes.XTSAESCipher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.params.KeyParameter;

public class NCAProvider {
    private static final Logger log = LogManager.getLogger(NCAProvider.class);
    private final File file;
    private final long offset;
    private final HashMap<String, String> keys;
    private byte[] rsa2048one;
    private byte[] rsa2048two;
    private String magicNumber;
    private byte systemOrGcIndicator;
    private byte contentType;
    private byte cryptoType1;
    private byte keyIndex;
    private long ncaSize;
    private byte[] titleId;
    private byte[] contentIndx;
    private byte[] sdkVersion;
    private byte cryptoType2;
    private byte Header1SignatureKeyGeneration;
    private byte[] keyGenerationReserved;
    private byte[] rightsId;
    private byte cryptoTypeReal;
    private byte[] sha256hash0;
    private byte[] sha256hash1;
    private byte[] sha256hash2;
    private byte[] sha256hash3;
    private byte[] encryptedKey0;
    private byte[] encryptedKey1;
    private byte[] encryptedKey2;
    private byte[] encryptedKey3;
    private byte[] decryptedKey0;
    private byte[] decryptedKey1;
    private byte[] decryptedKey2;
    private byte[] decryptedKey3;
    private NCAHeaderTableEntry tableEntry0;
    private NCAHeaderTableEntry tableEntry1;
    private NCAHeaderTableEntry tableEntry2;
    private NCAHeaderTableEntry tableEntry3;
    private NcaFsHeader sectionBlock0;
    private NcaFsHeader sectionBlock1;
    private NcaFsHeader sectionBlock2;
    private NcaFsHeader sectionBlock3;
    private NCAContent ncaContent0;
    private NCAContent ncaContent1;
    private NCAContent ncaContent2;
    private NCAContent ncaContent3;

    public NCAProvider(File file, HashMap<String, String> keys) throws Exception {
        this(file, keys, 0L);
    }

    public NCAProvider(File file, HashMap<String, String> keys, long offsetPosition) throws Exception {
        this.file = file;
        this.keys = keys;
        String header_key = keys.get("header_key");
        if (header_key == null) {
            throw new Exception("header_key is not found within key set provided.");
        }
        if (header_key.length() != 64) {
            throw new Exception("header_key is too small or too big. Must be 64 symbols.");
        }
        this.offset = offsetPosition;
        KeyParameter key1 = new KeyParameter(this.hexStrToByteArray(header_key.substring(0, 32)));
        KeyParameter key2 = new KeyParameter(this.hexStrToByteArray(header_key.substring(32, 64)));
        XTSAESCipher xtsaesCipher = new XTSAESCipher(false);
        xtsaesCipher.init(false, key1, key2);
        byte[] decryptedHeader = new byte[3072];
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            byte[] encryptedSequence = new byte[512];
            raf.seek(offsetPosition);
            for (int i = 0; i < 6; ++i) {
                if (raf.read(encryptedSequence) != 512) {
                    throw new Exception("Read error " + i);
                }
                byte[] decryptedSequence = new byte[512];
                xtsaesCipher.processDataUnit(encryptedSequence, 0, 512, decryptedSequence, 0, i);
                System.arraycopy(decryptedSequence, 0, decryptedHeader, i * 512, 512);
            }
            this.setupHeader(decryptedHeader);
        }
        this.setupNCAContent();
    }

    private byte[] hexStrToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private void setupHeader(byte[] decryptedData) throws Exception {
        this.rsa2048one = Arrays.copyOfRange(decryptedData, 0, 256);
        this.rsa2048two = Arrays.copyOfRange(decryptedData, 256, 512);
        this.magicNumber = new String(decryptedData, 512, 4, StandardCharsets.US_ASCII);
        this.systemOrGcIndicator = decryptedData[516];
        this.contentType = decryptedData[517];
        this.cryptoType1 = decryptedData[518];
        this.keyIndex = decryptedData[519];
        this.ncaSize = Converter.getLElong(decryptedData, 520);
        this.titleId = Converter.flip(Arrays.copyOfRange(decryptedData, 528, 536));
        this.contentIndx = Arrays.copyOfRange(decryptedData, 536, 540);
        this.sdkVersion = Arrays.copyOfRange(decryptedData, 540, 544);
        this.cryptoType2 = decryptedData[544];
        this.Header1SignatureKeyGeneration = decryptedData[545];
        this.keyGenerationReserved = Arrays.copyOfRange(decryptedData, 546, 560);
        this.rightsId = Arrays.copyOfRange(decryptedData, 560, 576);
        byte[] tableBytes = Arrays.copyOfRange(decryptedData, 576, 640);
        byte[] sha256tableBytes = Arrays.copyOfRange(decryptedData, 640, 768);
        this.sha256hash0 = Arrays.copyOfRange(sha256tableBytes, 0, 32);
        this.sha256hash1 = Arrays.copyOfRange(sha256tableBytes, 32, 64);
        this.sha256hash2 = Arrays.copyOfRange(sha256tableBytes, 64, 96);
        this.sha256hash3 = Arrays.copyOfRange(sha256tableBytes, 96, 128);
        byte[] encryptedKeysArea = Arrays.copyOfRange(decryptedData, 768, 832);
        this.encryptedKey0 = Arrays.copyOfRange(encryptedKeysArea, 0, 16);
        this.encryptedKey1 = Arrays.copyOfRange(encryptedKeysArea, 16, 32);
        this.encryptedKey2 = Arrays.copyOfRange(encryptedKeysArea, 32, 48);
        this.encryptedKey3 = Arrays.copyOfRange(encryptedKeysArea, 48, 64);
        this.cryptoTypeReal = this.cryptoType1 < this.cryptoType2 ? this.cryptoType2 : this.cryptoType1;
        if (this.cryptoTypeReal > 0) {
            this.cryptoTypeReal = (byte)(this.cryptoTypeReal - 1);
        }
        if (!this.magicNumber.equalsIgnoreCase("NCA3")) {
            throw new Exception("Not supported data type: " + this.magicNumber + ". Only NCA3 supported");
        }
        if (Arrays.equals(this.rightsId, new byte[16])) {
            String keyAreaKey;
            switch (this.keyIndex) {
                case 0: {
                    keyAreaKey = this.keys.get(String.format("key_area_key_application_%02x", this.cryptoTypeReal));
                    break;
                }
                case 1: {
                    keyAreaKey = this.keys.get(String.format("key_area_key_ocean_%02x", this.cryptoTypeReal));
                    break;
                }
                case 2: {
                    keyAreaKey = this.keys.get(String.format("key_area_key_system_%02x", this.cryptoTypeReal));
                    break;
                }
                default: {
                    keyAreaKey = null;
                }
            }
            if (keyAreaKey != null) {
                SecretKeySpec skSpec = new SecretKeySpec(this.hexStrToByteArray(keyAreaKey), "AES");
                Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
                cipher.init(2, skSpec);
                this.decryptedKey0 = cipher.doFinal(this.encryptedKey0);
                this.decryptedKey1 = cipher.doFinal(this.encryptedKey1);
                this.decryptedKey2 = cipher.doFinal(this.encryptedKey2);
                this.decryptedKey3 = cipher.doFinal(this.encryptedKey3);
            } else {
                this.keyAreaKeyNotSupportedOrFound();
            }
        }
        this.tableEntry0 = new NCAHeaderTableEntry(tableBytes);
        this.tableEntry1 = new NCAHeaderTableEntry(Arrays.copyOfRange(tableBytes, 16, 32));
        this.tableEntry2 = new NCAHeaderTableEntry(Arrays.copyOfRange(tableBytes, 32, 48));
        this.tableEntry3 = new NCAHeaderTableEntry(Arrays.copyOfRange(tableBytes, 48, 64));
        this.sectionBlock0 = new NcaFsHeader(Arrays.copyOfRange(decryptedData, 1024, 1536));
        this.sectionBlock1 = new NcaFsHeader(Arrays.copyOfRange(decryptedData, 1536, 2048));
        this.sectionBlock2 = new NcaFsHeader(Arrays.copyOfRange(decryptedData, 2048, 2560));
        this.sectionBlock3 = new NcaFsHeader(Arrays.copyOfRange(decryptedData, 2560, 3072));
    }

    private void keyAreaKeyNotSupportedOrFound() throws Exception {
        StringBuilder exceptionStringBuilder = new StringBuilder("key_area_key_");
        switch (this.keyIndex) {
            case 0: {
                exceptionStringBuilder.append("application_");
                break;
            }
            case 1: {
                exceptionStringBuilder.append("ocean_");
                break;
            }
            case 2: {
                exceptionStringBuilder.append("system_");
                break;
            }
            default: {
                exceptionStringBuilder.append(this.keyIndex);
                exceptionStringBuilder.append("[UNKNOWN]_");
            }
        }
        exceptionStringBuilder.append(String.format("%02x", this.cryptoTypeReal));
        exceptionStringBuilder.append(" requested. Not supported or not found.");
        throw new Exception(exceptionStringBuilder.toString());
    }

    private void setupNCAContent() throws Exception {
        byte[] key = this.calculateKey();
        this.setupNcaContentByNumber(0, key);
        this.setupNcaContentByNumber(1, key);
        this.setupNcaContentByNumber(2, key);
        this.setupNcaContentByNumber(3, key);
    }

    private byte[] calculateKey() throws Exception {
        try {
            if (Arrays.equals(this.rightsId, new byte[16])) {
                return this.decryptedKey2;
            }
            byte[] rightsIdKey = this.hexStrToByteArray(this.keys.get(Converter.byteArrToHexStringAsLE(this.rightsId)));
            SecretKeySpec skSpec = new SecretKeySpec(this.hexStrToByteArray(this.keys.get(String.format("titlekek_%02x", this.cryptoTypeReal))), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(2, skSpec);
            return cipher.doFinal(rightsIdKey);
        }
        catch (Exception e) {
            throw new Exception("No title.keys loaded for '" + String.format("titlekek_%02x", this.cryptoTypeReal) + "' or '" + Converter.byteArrToHexStringAsLE(this.rightsId) + "'? (" + e + ")", e);
        }
    }

    private void setupNcaContentByNumber(int number, byte[] key) {
        try {
            switch (number) {
                case 0: {
                    this.ncaContent0 = new NCAContent(this.file, this.offset, this.sectionBlock0, this.tableEntry0, key);
                    break;
                }
                case 1: {
                    this.ncaContent1 = new NCAContent(this.file, this.offset, this.sectionBlock1, this.tableEntry1, key);
                    break;
                }
                case 2: {
                    this.ncaContent2 = new NCAContent(this.file, this.offset, this.sectionBlock2, this.tableEntry2, key);
                    break;
                }
                case 3: {
                    this.ncaContent3 = new NCAContent(this.file, this.offset, this.sectionBlock3, this.tableEntry3, key);
                }
            }
        }
        catch (EmptySectionException emptySectionException) {
        }
        catch (Exception e) {
            log.debug("Unable to get NCA Content " + number + " (" + this.file.getParentFile().getName() + "/" + this.file.getName() + ")", (Throwable)e);
        }
    }

    public byte[] getRsa2048one() {
        return this.rsa2048one;
    }

    public byte[] getRsa2048two() {
        return this.rsa2048two;
    }

    public String getMagicnum() {
        return this.magicNumber;
    }

    public byte getSystemOrGcIndicator() {
        return this.systemOrGcIndicator;
    }

    public byte getContentType() {
        return this.contentType;
    }

    public byte getCryptoType1() {
        return this.cryptoType1;
    }

    public byte getKeyIndex() {
        return this.keyIndex;
    }

    public long getNcaSize() {
        return this.ncaSize;
    }

    public byte[] getTitleId() {
        return this.titleId;
    }

    public byte[] getContentIndx() {
        return this.contentIndx;
    }

    public byte[] getSdkVersion() {
        return this.sdkVersion;
    }

    public byte getCryptoType2() {
        return this.cryptoType2;
    }

    public byte getHeader1SignatureKeyGeneration() {
        return this.Header1SignatureKeyGeneration;
    }

    public byte[] getKeyGenerationReserved() {
        return this.keyGenerationReserved;
    }

    public byte[] getRightsId() {
        return this.rightsId;
    }

    public byte[] getSha256hash0() {
        return this.sha256hash0;
    }

    public byte[] getSha256hash1() {
        return this.sha256hash1;
    }

    public byte[] getSha256hash2() {
        return this.sha256hash2;
    }

    public byte[] getSha256hash3() {
        return this.sha256hash3;
    }

    public byte[] getEncryptedKey0() {
        return this.encryptedKey0;
    }

    public byte[] getEncryptedKey1() {
        return this.encryptedKey1;
    }

    public byte[] getEncryptedKey2() {
        return this.encryptedKey2;
    }

    public byte[] getEncryptedKey3() {
        return this.encryptedKey3;
    }

    public byte[] getDecryptedKey0() {
        return this.decryptedKey0;
    }

    public byte[] getDecryptedKey1() {
        return this.decryptedKey1;
    }

    public byte[] getDecryptedKey2() {
        return this.decryptedKey2;
    }

    public byte[] getDecryptedKey3() {
        return this.decryptedKey3;
    }

    public NCAHeaderTableEntry getTableEntry(int id) throws Exception {
        switch (id) {
            case 0: {
                return this.getTableEntry0();
            }
            case 1: {
                return this.getTableEntry1();
            }
            case 2: {
                return this.getTableEntry2();
            }
            case 3: {
                return this.getTableEntry3();
            }
        }
        throw new Exception("NCA Table Entry must be defined in range 0-3 while '" + id + "' requested");
    }

    public NCAHeaderTableEntry getTableEntry0() {
        return this.tableEntry0;
    }

    public NCAHeaderTableEntry getTableEntry1() {
        return this.tableEntry1;
    }

    public NCAHeaderTableEntry getTableEntry2() {
        return this.tableEntry2;
    }

    public NCAHeaderTableEntry getTableEntry3() {
        return this.tableEntry3;
    }

    public NcaFsHeader getSectionBlock(int id) throws Exception {
        switch (id) {
            case 0: {
                return this.getSectionBlock0();
            }
            case 1: {
                return this.getSectionBlock1();
            }
            case 2: {
                return this.getSectionBlock2();
            }
            case 3: {
                return this.getSectionBlock3();
            }
        }
        throw new Exception("NCA Section Block must be defined in range 0-3 while '" + id + "' requested");
    }

    public NcaFsHeader getSectionBlock0() {
        return this.sectionBlock0;
    }

    public NcaFsHeader getSectionBlock1() {
        return this.sectionBlock1;
    }

    public NcaFsHeader getSectionBlock2() {
        return this.sectionBlock2;
    }

    public NcaFsHeader getSectionBlock3() {
        return this.sectionBlock3;
    }

    public boolean isKeyAvailable() {
        if (Arrays.equals(this.rightsId, new byte[16])) {
            return false;
        }
        return this.keys.containsKey(Converter.byteArrToHexStringAsLE(this.rightsId));
    }

    public NCAContent getNCAContentProvider(int sectionNumber) throws Exception {
        switch (sectionNumber) {
            case 0: {
                return this.ncaContent0;
            }
            case 1: {
                return this.ncaContent1;
            }
            case 2: {
                return this.ncaContent2;
            }
            case 3: {
                return this.ncaContent3;
            }
        }
        throw new Exception("NCA Content must be requested in range of 0-3, while 'Section Number " + sectionNumber + "' requested");
    }

    public File getFile() {
        return this.file;
    }
}

