/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public abstract class ExportAble {
    protected BufferedInputStream stream;

    protected boolean export(String saveTo, String fileName, long skip, long size) throws Exception {
        if (skip != this.stream.skip(skip)) {
            throw new Exception("Can't seek to start position: " + skip);
        }
        File location = new File(saveTo);
        location.mkdirs();
        try (BufferedOutputStream extractedFileBOS = new BufferedOutputStream(Files.newOutputStream(Paths.get(saveTo + File.separator + fileName, new String[0]), new OpenOption[0]));){
            int blockSize = 512;
            if (size < 512L) {
                blockSize = (int)size;
            }
            long i = 0L;
            byte[] block = new byte[blockSize];
            while (true) {
                int actuallyRead;
                if ((actuallyRead = this.stream.read(block)) != blockSize) {
                    throw new Exception("Read failure. " + blockSize + "/" + actuallyRead);
                }
                extractedFileBOS.write(block);
                if ((i += (long)blockSize) + (long)blockSize <= size) continue;
                blockSize = (int)(size - i);
                if (blockSize == 0) {
                    break;
                }
                block = new byte[blockSize];
            }
        }
        this.stream.close();
        return true;
    }
}

