/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;

public class KeyChainHolder {
    private final File keysFile;
    private final String xci_header_key;
    private HashMap<String, String> rawKeySet;
    private HashMap<String, String> key_area_key_application;
    private HashMap<String, String> key_area_key_ocean;
    private HashMap<String, String> key_area_key_system;
    private HashMap<String, String> titlekek;

    public KeyChainHolder(String pathToKeysFile, String xci_header_key) throws Exception {
        this(new File(pathToKeysFile), xci_header_key);
    }

    public KeyChainHolder(File keysFile, String xci_header_key) throws Exception {
        this.keysFile = keysFile;
        this.xci_header_key = xci_header_key;
        this.collectEverything();
    }

    private void collectEverything() throws Exception {
        String fileLine;
        this.rawKeySet = new HashMap();
        BufferedReader br = new BufferedReader(new FileReader(this.keysFile));
        while ((fileLine = br.readLine()) != null) {
            String[] keyValue = fileLine.trim().split("\\s+?=\\s+?", 2);
            if (keyValue.length != 2) continue;
            this.rawKeySet.put(keyValue[0], keyValue[1]);
        }
        this.key_area_key_application = this.collectKeysByType("key_area_key_application");
        this.key_area_key_ocean = this.collectKeysByType("key_area_key_ocean");
        this.key_area_key_system = this.collectKeysByType("key_area_key_system");
        this.titlekek = this.collectKeysByType("titlekek");
    }

    private HashMap<String, String> collectKeysByType(String keyName) {
        String keyParsed;
        HashMap<String, String> tempKeySet = new HashMap<String, String>();
        String keyNamePattern = keyName + "_%02x";
        int counter = 0;
        while ((keyParsed = this.rawKeySet.get(String.format(keyNamePattern, counter))) != null) {
            tempKeySet.put(String.format(keyNamePattern, counter), keyParsed);
            ++counter;
        }
        return tempKeySet;
    }

    public String getXci_header_key() {
        return this.xci_header_key;
    }

    public String getHeader_key() {
        return this.rawKeySet.get("header_key");
    }

    public HashMap<String, String> getRawKeySet() {
        return this.rawKeySet;
    }

    public HashMap<String, String> getKey_area_key_application() {
        return this.key_area_key_application;
    }

    public HashMap<String, String> getKey_area_key_ocean() {
        return this.key_area_key_ocean;
    }

    public HashMap<String, String> getKey_area_key_system() {
        return this.key_area_key_system;
    }

    public HashMap<String, String> getTitlekek() {
        return this.titlekek;
    }
}

