"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sscaff = void 0;
const fs_1 = require("fs");
const path = __importStar(require("path"));
const substitute_1 = require("./substitute");
const hooksFile = '.hooks.sscaff.js';
/**
 * Copy all files from `templateDir` to `targetDir` and substitute all variables
 * in file names and their contents. Substitutions take the form `{{ key }}`.
 *
 * @param sourceDir
 * @param targetDir
 * @param variables
 */
async function sscaff(sourceDir, targetDir, variables = {}) {
    sourceDir = path.resolve(sourceDir);
    targetDir = path.resolve(targetDir);
    await fs_1.promises.mkdir(targetDir, { recursive: true });
    const hooks = loadHooks();
    if (!variables.$base) {
        variables.$base = path.basename(targetDir);
    }
    const restore = process.cwd();
    try {
        process.chdir(targetDir);
        await executePreHook();
        await processDirectory('.');
        await executePostHook();
    }
    finally {
        process.chdir(restore);
    }
    async function processDirectory(subdir) {
        const subPath = path.join(sourceDir, subdir);
        for (const file of await fs_1.promises.readdir(subPath)) {
            if (file === hooksFile) {
                continue;
            }
            const sourcePath = path.join(subPath, file);
            if ((await fs_1.promises.stat(sourcePath)).isDirectory()) {
                await processDirectory(path.join(subdir, file));
                continue;
            }
            const targetPath = substitute_1.substitute(path.join(subdir, file), variables);
            const input = await fs_1.promises.readFile(sourcePath, 'utf-8');
            const output = substitute_1.substitute(input.toString(), variables);
            await fs_1.promises.mkdir(path.dirname(targetPath), { recursive: true });
            await fs_1.promises.writeFile(targetPath, output);
        }
    }
    async function executePreHook() {
        if (!(hooks === null || hooks === void 0 ? void 0 : hooks.pre)) {
            return;
        }
        await Promise.resolve(hooks.pre(variables));
    }
    async function executePostHook() {
        if (!(hooks === null || hooks === void 0 ? void 0 : hooks.post)) {
            return;
        }
        await Promise.resolve(hooks.post(variables));
    }
    function loadHooks() {
        try {
            // eslint-disable-next-line @typescript-eslint/no-require-imports
            return require(path.join(sourceDir, hooksFile));
        }
        catch {
            return undefined;
        }
    }
}
exports.sscaff = sscaff;
//# sourceMappingURL=data:application/json;base64,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