"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GO_RESERVED = exports.PYTHON_RESERVED = exports.JAVA_RESERVED = exports.CSHARP_RESERVED = void 0;
exports.isReservedName = isReservedName;
function isReservedName(name) {
    const reserved = new Array();
    if (exports.CSHARP_RESERVED.has(name)) {
        reserved.push('C#');
    }
    if (exports.JAVA_RESERVED.has(name)) {
        reserved.push('Java');
    }
    if (exports.PYTHON_RESERVED.has(name)) {
        reserved.push('Python');
    }
    if (exports.GO_RESERVED.has(name)) {
        reserved.push('Go');
    }
    return reserved.length > 0 ? reserved : undefined;
}
exports.CSHARP_RESERVED = new Set([
    'abstract',
    'as',
    'base',
    'bool',
    'break',
    'byte',
    'case',
    'catch',
    'char',
    'checked',
    'class',
    'const',
    'continue',
    'decimal',
    'default',
    'delegate',
    'do',
    'double',
    'else',
    'enum',
    'event',
    'explicit',
    'extern',
    'false',
    'finally',
    'fixed',
    'float',
    'for',
    'foreach',
    'goto',
    'if',
    'implicit',
    'in',
    'int',
    'interface',
    'internal',
    'is',
    'lock',
    'long',
    'namespace',
    'new',
    'null',
    'object',
    'operator',
    'out',
    'override',
    'params',
    'private',
    'protected',
    'public',
    'readonly',
    'ref',
    'return',
    'sbyte',
    'sealed',
    'short',
    'sizeof',
    'stackalloc',
    'static',
    'string',
    'struct',
    'switch',
    'this',
    'throw',
    'true',
    'try',
    'typeof',
    'uint',
    'ulong',
    'unchecked',
    'unsafe',
    'ushort',
    'using',
    'virtual',
    'void',
    'volatile',
    'while',
]);
exports.JAVA_RESERVED = new Set([
    'abstract',
    'continue',
    'for',
    'new',
    'switch',
    'assert',
    'default',
    'goto',
    'package',
    'synchronized',
    'boolean',
    'do',
    'if',
    'private',
    'this',
    'break',
    'double',
    'implements',
    'protected',
    'throw',
    'byte',
    'else',
    'import',
    'public',
    'throws',
    'case',
    'enum',
    'instanceof',
    'return',
    'transient',
    'catch',
    'extends',
    'int',
    'short',
    'try',
    'char',
    'final',
    'interface',
    'static',
    'void',
    'class',
    'finally',
    'long',
    'strictfp',
    'volatile',
    'const',
    'float',
    'native',
    'super',
    'while',
    'true',
    'false',
    'null',
]);
exports.PYTHON_RESERVED = new Set([
    'False',
    'class',
    'finally',
    'is',
    'return',
    'None',
    'continue',
    'for',
    'lambda',
    'try',
    'True',
    'def',
    'from',
    'nonlocal',
    'while',
    'and',
    'del',
    'global',
    'not',
    'with',
    'as',
    'elif',
    'if',
    'or',
    'yield',
    'assert',
    'else',
    'import',
    'pass',
    'break',
    'except',
    'in',
    'raise',
    'self',
]);
exports.GO_RESERVED = new Set([
    'break',
    'case',
    'chan',
    'const',
    'continue',
    'default',
    'defer',
    'else',
    'fallthrough',
    'for',
    'func',
    'go',
    'goto',
    'if',
    'import',
    'interface',
    'map',
    'package',
    'range',
    'return',
    'select',
    'struct',
    'switch',
    'type',
    'var',
    // constants
    'true',
    'false',
    'iota',
    'nil',
    // types
    'int',
    'int8',
    'int16',
    'int32',
    'int64',
    'uint',
    'uint8',
    'uint16',
    'uint32',
    'uint64',
    'uintptr',
    'float32',
    'float64',
    'complex128',
    'complex64',
    'bool',
    'rune',
    'byte',
    'string',
    'error',
    // functions
    'make',
    'len',
    'cap',
    'new',
    'append',
    'copy',
    'close',
    'delete',
    'complex',
    'real',
    'imag',
    'panic',
    'recover',
]);
//# sourceMappingURL=reserved-words.js.map