"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _Code_defaultCategory, _Code_category, _Code_formatter, _JsiiDiagnostic_formatted;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiDiagnostic = exports.Code = void 0;
exports.configureCategories = configureCategories;
const spec = require("@jsii/spec");
const case_1 = require("case");
const ts = require("typescript");
const deprecation_warnings_1 = require("./transforms/deprecation-warnings");
const utils_1 = require("./utils");
/**
 * Descriptors for all valid jsii diagnostic codes.
 *
 * The `category` or non-error codes can be updated, for example to treat
 * warnings as errors, or to suppress certain undesirable warnings.
 */
class Code {
    /**
     * @internal
     */
    static message({ code, name, formatter, }) {
        return new Code(code, name, ts.DiagnosticCategory.Message, formatter);
    }
    /**
     * @internal
     */
    static suggestion({ code, name, formatter, }) {
        return new Code(code, name, ts.DiagnosticCategory.Suggestion, formatter);
    }
    /**
     * @internal
     */
    static warning({ code, name, formatter, }) {
        return new Code(code, name, ts.DiagnosticCategory.Warning, formatter);
    }
    /**
     * @internal
     */
    static error({ code, name, formatter, }) {
        return new Code(code, name, ts.DiagnosticCategory.Error, formatter);
    }
    /**
     * Get a diagnostic code by code or name.
     *
     * @param codeOrName the looked up diagnostic code or name.
     *
     * @returns the JsiiDiagnosticCode instande, if one exists, or `undefined`
     *
     * @experimental this module is under active development and the error codes
     *               and names may change in the future.
     */
    static lookup(codeOrName) {
        if (typeof codeOrName === 'number') {
            return this.byCode.get(codeOrName);
        }
        return this.byName.get(codeOrName);
    }
    /**
     * Registers a new diagnostic code.
     *
     * @param code            the numeric code for the diagnostic
     * @param name            the symbolic name for the diagnostic
     * @param defaultCategory the default category this diagnostic ranks in
     * @param formatter       a message formatter for easy creation of diagnostics
     */
    constructor(code, name, defaultCategory, formatter) {
        this.code = code;
        this.name = name;
        // eslint-disable-next-line @typescript-eslint/explicit-member-accessibility
        _Code_defaultCategory.set(this, void 0);
        // eslint-disable-next-line @typescript-eslint/explicit-member-accessibility
        _Code_category.set(this, void 0);
        // eslint-disable-next-line @typescript-eslint/explicit-member-accessibility
        _Code_formatter.set(this, void 0);
        __classPrivateFieldSet(this, _Code_defaultCategory, defaultCategory, "f");
        __classPrivateFieldSet(this, _Code_formatter, formatter, "f");
        if (code in Code.byCode) {
            throw new Error(`Attempted to create two instances of ${this.constructor.name} with code ${code}`);
        }
        if (name in Code.byName) {
            throw new Error(`Attempted to create two instances of ${this.constructor.name} with name ${name}`);
        }
        Code.byCode.set(code, this);
        Code.byName.set(name, this);
    }
    /**
     * Determines whether this diagnostic is a compilation error. Diagnostics
     * where this is `true` cannot have their `category` overridden to a lower
     * category.
     */
    get isError() {
        return __classPrivateFieldGet(this, _Code_defaultCategory, "f") === ts.DiagnosticCategory.Error;
    }
    /**
     * The diagnostic category this particular code is filed as.
     */
    get category() {
        return __classPrivateFieldGet(this, _Code_category, "f") ?? __classPrivateFieldGet(this, _Code_defaultCategory, "f");
    }
    /**
     * Update the diagnostic category for this particular code. If `isError` is
     * `true`, attempting to set anything other than `ts.DiagnosticCategory.Error`
     * will result in an error being throw.
     *
     * @param newValue the new diagnostic category to be used.
     */
    set category(newValue) {
        if (this.isError && newValue !== ts.DiagnosticCategory.Error) {
            throw new Error(`Illegal attempt to override category of error ${this.code} to ${ts.DiagnosticCategory[newValue]}`);
        }
        __classPrivateFieldSet(this, _Code_category, newValue, "f");
    }
    /**
     * Creates a new `JsiiDiagnostic` message without any source code location
     * data.
     *
     * @param args the arguments to the message formatter.
     *
     * @deprecated It is preferred to specify a source code location for problem
     *             markers. Prefer the use of `create` while providing a value
     *             for the `location` parameter whenever possible.
     */
    createDetached(...args) {
        return new JsiiDiagnostic(this, __classPrivateFieldGet(this, _Code_formatter, "f").call(this, ...args));
    }
    /**
     * Creates a new `JsiiDiagnostic` message with source code location denoted
     * by the provided `location` node.
     *
     * @param location the source code location attachment of the message.
     * @param args     the arguments to the message formatter.
     */
    create(location, ...args) {
        return new JsiiDiagnostic(this, __classPrivateFieldGet(this, _Code_formatter, "f").call(this, ...args), location);
    }
}
exports.Code = Code;
_Code_defaultCategory = new WeakMap(), _Code_category = new WeakMap(), _Code_formatter = new WeakMap();
Code.byCode = new Map();
Code.byName = new Map();
/**
 * A jsii-specific diagnostic entry.
 */
class JsiiDiagnostic {
    //////////////////////////////////////////////////////////////////////////////
    /**
     * Determines whether a `Diagnostic` instance is a `JsiiDiagnostic` or not.
     * @param diag
     */
    static isJsiiDiagnostic(diag) {
        return diag.domain === JsiiDiagnostic.DOMAIN;
    }
    /**
     * Creates a new `JsiiDiagnostic` with the provided properties.
     *
     * @internal
     */
    constructor(code, messageText, location) {
        this.domain = JsiiDiagnostic.DOMAIN;
        this.code = utils_1.JSII_DIAGNOSTICS_CODE;
        this.relatedInformation = new Array();
        // eslint-disable-next-line @typescript-eslint/explicit-member-accessibility
        _JsiiDiagnostic_formatted.set(this, void 0);
        this.category = code.category;
        this.jsiiCode = code.code;
        this.messageText = messageText;
        if (location != null) {
            this.file = location.getSourceFile();
            this.start = location.getStart(this.file);
            this.length = location.getEnd() - this.start;
        }
    }
    addRelatedInformation(node, message) {
        // Don't relate info into the TypeScript standard library
        if (!/[\\/]typescript[\\/]lib[\\/]lib\..+\.d\.ts$/.test(node.getSourceFile().fileName)) {
            this.relatedInformation.push(JsiiDiagnostic.JSII_9999_RELATED_INFO.create(node, message));
        }
        // Clearing out #formatted, as this would no longer be the correct string.
        __classPrivateFieldSet(this, _JsiiDiagnostic_formatted, undefined, "f");
        return this;
    }
    /**
     * Links the provided `node` with the specified `message` as related to the
     * current diagnostic, unless `node` is undefined.
     *
     * @param node the node where the message should be attached, if any.
     * @param message the message to be attached to the diagnostic entry.
     *
     * @returns `this`
     */
    addRelatedInformationIf(node, message) {
        if (node != null) {
            return this.addRelatedInformation(node, message);
        }
        else {
            return this;
        }
    }
    /**
     * Adds related information to this `JsiiDiagnostic` instance if the provided
     * `node` is defined.
     *
     * @param node    the node to bind as related information, or `undefined`.
     * @param message the message to attach to the related information.
     *
     * @returns `this`
     */
    maybeAddRelatedInformation(node, message) {
        if (node == null) {
            return this;
        }
        this.relatedInformation.push(JsiiDiagnostic.JSII_9999_RELATED_INFO.create(node, message));
        // Clearing out #formatted, as this would no longer be the correct string.
        __classPrivateFieldSet(this, _JsiiDiagnostic_formatted, undefined, "f");
        return this;
    }
    /**
     * Formats this diagnostic with color and context if possible, and returns it.
     * The formatted diagnostic is cached, so that it can be re-used. This is
     * useful for diagnostic messages involving trivia -- as the trivia may have
     * been obliterated from the `SourceFile` by the `TsCommentReplacer`, which
     * makes the error messages really confusing.
     */
    format(projectRoot) {
        if (__classPrivateFieldGet(this, _JsiiDiagnostic_formatted, "f") == null) {
            __classPrivateFieldSet(this, _JsiiDiagnostic_formatted, (0, utils_1._formatDiagnostic)(this, projectRoot), "f");
        }
        return __classPrivateFieldGet(this, _JsiiDiagnostic_formatted, "f");
    }
}
exports.JsiiDiagnostic = JsiiDiagnostic;
_JsiiDiagnostic_formatted = new WeakMap();
//////////////////////////////////////////////////////////////////////////////
// 0001 => 0999 -- PACKAGE METADATA PROBLEMS
JsiiDiagnostic.JSII_0001_PKG_MISSING_DESCRIPTION = Code.suggestion({
    code: 1,
    formatter: () => 'A "description" field should be specified in "package.json"',
    name: 'metadata/package-json-missing-description',
});
JsiiDiagnostic.JSII_0002_PKG_MISSING_HOMEPAGE = Code.suggestion({
    code: 2,
    formatter: () => 'A "homepage" field should be specified in "package.json"',
    name: 'metadata/package-json-missing-homepage',
});
JsiiDiagnostic.JSII_0003_MISSING_README = Code.warning({
    code: 3,
    formatter: () => 'There is no "README.md" file. It is required in order to generate valid PyPI (Python) packages.',
    name: 'metadata/missing-readme',
});
JsiiDiagnostic.JSII_0004_COULD_NOT_FIND_ENTRYPOINT = Code.error({
    code: 4,
    formatter: (mainFile) => `Could not find "main" file: ${mainFile}`,
    name: 'metadata/could-not-find-entrypoint',
});
JsiiDiagnostic.JSII_0005_MISSING_PEER_DEPENDENCY = Code.warning({
    code: 5,
    formatter: (assm, reference) => `The type "${reference}" is exposed in the public API of this module. ` +
        `Therefore, the module "${assm}" must also be defined under "peerDependencies". ` +
        'This will be auto-corrected unless --no-fix-peer-dependencies was specified.',
    name: 'metadata/missing-peer-dependency',
});
// NOTE: currently not possible to change the severity of this code,
// as it's being emitted before the overrides have been loaded
JsiiDiagnostic.JSII_0006_MISSING_DEV_DEPENDENCY = Code.warning({
    code: 6,
    formatter: (dependencyName, peerRange, minVersion, actual) => `A "peerDependency" on "${dependencyName}" at "${peerRange}" means you ` +
        `should take a "devDependency" on "${dependencyName}" at "${minVersion}" ` +
        `(found ${JSON.stringify(actual)})`,
    name: 'metadata/missing-dev-dependency',
});
JsiiDiagnostic.JSII_0007_MISSING_WARNINGS_EXPORT = Code.error({
    code: 7,
    formatter: () => 'If you are compiling with --add-deprecation-warnings and your package.json ' +
        `declares subpath exports, you must include { "./${deprecation_warnings_1.WARNINGSCODE_FILE_NAME}": "./${deprecation_warnings_1.WARNINGSCODE_FILE_NAME}" } ` +
        'in the set of exports.',
    name: 'metadata/missing-warnings-export',
});
//////////////////////////////////////////////////////////////////////////////
// 1000 => 1999 -- TYPESCRIPT LANGUAGE RESTRICTIONS
JsiiDiagnostic.JSII_1000_NO_CONST_ENUM = Code.error({
    code: 1000,
    formatter: () => 'Exported "const enum" declarations are not allowed',
    name: 'typescript-restrictions/no-const-enum',
});
JsiiDiagnostic.JSII_1001_TYPE_HAS_NO_SYMBOL = Code.error({
    code: 1001,
    formatter: () => 'Non-primitive types without a symbol cannot be processed.',
    name: 'typescript-restrictions/type-has-no-symbol',
});
JsiiDiagnostic.JSII_1002_UNSPECIFIED_PROMISE = Code.error({
    code: 1002,
    formatter: () => 'Un-specified promise type. Specify it using "Promise<T>"',
    name: 'typescript-restrictions/unspecified-promise',
});
JsiiDiagnostic.JSII_1003_UNSUPPORTED_TYPE = Code.error({
    code: 1003,
    formatter: (messageText) => messageText,
    name: 'typescript-restrictions/unsupported-type',
});
JsiiDiagnostic.JSII_1004_DUPLICATE_ENUM_VALUE = Code.error({
    code: 1004,
    formatter: (enumValue, enumMemberNames) => `Value ${enumValue} is used for multiple enum values: ${enumMemberNames.join(', ')}`,
    name: 'typescript-restrictions/duplicate-enum-value',
});
JsiiDiagnostic.JSII_1005_SEPARATE_WRITE_TYPE = Code.error({
    code: 1005,
    formatter: () => 'Visible property signatures cannot use a separate write type. Use the same type as the getter.',
    name: 'typescript-restrictions/separate-write-type',
});
JsiiDiagnostic.JSII_1006_GENERIC_TYPE = Code.error({
    code: 1006,
    formatter: () => 'Generic types are not supported because semantics are not uniform in target languages.',
    name: 'typescript-restriction/generic-type',
});
JsiiDiagnostic.JSII_1999_UNSUPPORTED = Code.error({
    code: 1999,
    formatter: ({ what, alternative, suggestInternal, }) => `${what} are not supported in jsii APIs.${alternative ? ` Consider using ${alternative} instead.` : ''}${suggestInternal
        ? ` This declaration must${alternative ? ' otherwise' : ''} be marked "@internal" or "@jsii ignore".`
        : ''}`,
    name: 'typescript-restrictions/unsupported',
});
//////////////////////////////////////////////////////////////////////////////
// 2000 => 2999 -- INCORRECT USE OF THE @jsii DIRECTIVE
JsiiDiagnostic.JSII_2000_MISSING_DIRECTIVE_ARGUMENT = Code.warning({
    code: 2000,
    formatter: () => 'Missing argument to @jsii directive. Refer to the jsii compiler documentation for more information.',
    name: 'jsii-directive/missing-argument',
});
JsiiDiagnostic.JSII_2100_STRUCT_ON_NON_INTERFACE = Code.warning({
    code: 2100,
    formatter: () => 'The "@jsii struct" directive is only applicable to interface declarations.',
    name: 'jsii-directive/struct-on-non-interface',
});
JsiiDiagnostic.JSII_2999_UNKNOWN_DIRECTIVE = Code.warning({
    code: 2999,
    formatter: (text) => `Unknown @jsii directive: ${JSON.stringify(text)}. Refer to the jsii compiler documentation for more information.`,
    name: 'jsii-directive/unknown',
});
//////////////////////////////////////////////////////////////////////////////
// 3000 => 3999 -- TYPE MODEL COHERENCE
JsiiDiagnostic.JSII_3000_EXPORTED_API_USES_HIDDEN_TYPE = Code.error({
    code: 3000,
    formatter: (badFqn) => `Exported APIs cannot use un-exported type "${badFqn}"`,
    name: 'type-model/exported-api-cannot-use-unexported-type',
});
JsiiDiagnostic.JSII_3001_EXPOSED_INTERNAL_TYPE = Code.error({
    code: 3001,
    formatter: (symbol, isThisType, typeUse) => `Type ${isThisType ? `"this" (aka: "${symbol.name}")` : `"${symbol.name}"`} cannot be used as the ${typeUse} because it is private or @internal`,
    name: 'type-model/use-of-internal-type',
});
JsiiDiagnostic.JSII_3002_USE_OF_UNEXPORTED_FOREIGN_TYPE = Code.error({
    code: 3002,
    formatter: (fqn, typeUse, pkg) => `Type "${fqn}" cannot be used as a ${typeUse} because it is not exported from ${pkg.name}`,
    name: 'type-model/unexported-foreign-type',
});
JsiiDiagnostic.JSII_3003_SYMBOL_IS_EXPORTED_TWICE = Code.error({
    code: 3003,
    formatter: (ns1, ns2) => `Symbol is exported under two distinct submodules: ${ns1} and ${ns2}`,
    name: 'type-model/symbol-is-exported-twice',
});
JsiiDiagnostic.JSII_3004_INVALID_SUPERTYPE = Code.error({
    code: 3004,
    formatter: (clause, badDeclaration) => {
        return `Illegal ${clauseType(clause.token)} clause for an exported API: ${ts.SyntaxKind[badDeclaration.kind]}`;
        function clauseType(token) {
            switch (token) {
                case ts.SyntaxKind.ExtendsKeyword:
                    return 'extends';
                case ts.SyntaxKind.ImplementsKeyword:
                    return 'implements';
                default:
                    return ts.SyntaxKind[token];
            }
        }
    },
    name: 'type-model/invalid-supertype',
});
JsiiDiagnostic.JSII_3005_TYPE_USED_AS_INTERFACE = Code.error({
    code: 3005,
    formatter: (badType) => `Type "${spec.describeTypeReference(badType)}" cannot be used as an interface`,
    name: 'type-model/type-used-as-interface',
});
JsiiDiagnostic.JSII_3006_TYPE_USED_AS_CLASS = Code.error({
    code: 3006,
    formatter: (badType) => `Type "${spec.describeTypeReference(badType)}" cannot be used as a class`,
    name: 'type-model/type-used-as-class',
});
JsiiDiagnostic.JSII_3007_ILLEGAL_STRUCT_EXTENSION = Code.error({
    code: 3007,
    formatter: (offender, struct) => `Attempt to extend or implement struct "${struct.fqn}" from "${offender.fqn}"`,
    name: 'type-model/illegal-struct-extension',
});
JsiiDiagnostic.JSII_3008_STRUCT_PROPS_MUST_BE_READONLY = Code.error({
    code: 3008,
    formatter: (propName, struct) => `The "${propName}" property of struct "${struct.fqn}" must be "readonly". Rename "${struct.fqn}" to "I${struct.name}" if it is meant to be a behavioral interface.`,
    name: 'type-model/struct-props-must-be-readonly',
});
JsiiDiagnostic.JSII_3009_OPTIONAL_PARAMETER_BEFORE_REQUIRED = Code.error({
    code: 3009,
    formatter: (param, nextParam) => `Parameter "${param.name}" cannot be optional, as it precedes required parameter "${nextParam.name}"`,
    name: 'type-model/optional-parameter-before-required',
});
JsiiDiagnostic.JSII_3999_INCOHERENT_TYPE_MODEL = Code.error({
    code: 3999,
    formatter: (messageText) => messageText,
    name: 'type-model/incoherent-type-model',
});
//////////////////////////////////////////////////////////////////////////////
// 4000 => 4999 -- TYPESCRIPT & JSII CONFIG ERRORS
JsiiDiagnostic.JSII_4000_FAILED_TSCONFIG_VALIDATION = Code.error({
    code: 4000,
    formatter: (config, ruleSet, violations) => {
        return `Typescript compiler options in "${config}" are not passing validation against rule set "${ruleSet}", found the following rule violations:\n${violations
            .map((v) => `  - ${v.field}: ${v.message}`)
            .join('\n')}`;
    },
    name: 'typescript-config/invalid-tsconfig',
});
JsiiDiagnostic.JSII_4009_DISABLED_TSCONFIG_VALIDATION = Code.warning({
    code: 4009,
    formatter: (config) => `Validation of typescript config "${config}" is disabled. This is intended for experimental setups only. Compilation might fail or produce incompatible artifacts.`,
    name: 'typescript-config/disabled-tsconfig-validation',
});
//////////////////////////////////////////////////////////////////////////////
// 5000 => 5999 -- LANGUAGE COMPATIBILITY ERRORS
JsiiDiagnostic.JSII_5000_JAVA_GETTERS = Code.error({
    code: 5000,
    formatter: (badName, typeName) => `Methods and properties cannot have names like "getXxx": those conflict with Java property getters. Rename "${typeName}.${badName}"`,
    name: 'language-compatibility/potential-java-getter-conflict',
});
JsiiDiagnostic.JSII_5001_JAVA_SETTERS = Code.error({
    code: 5001,
    formatter: (badName, typeName) => `Methods and properties cannot have names like "setXxx": those conflict with Java property setters. Rename "${typeName}.${badName}"`,
    name: 'language-compatibility/potential-java-setter-conflict',
});
JsiiDiagnostic.JSII_5002_OVERRIDE_CHANGES_VISIBILITY = Code.error({
    code: 5002,
    formatter: (newElement, action, newValue, oldValue) => `"${newElement}" changes visibility to ${newValue} when ${action}. Change it to ${oldValue}`,
    name: 'language-compatibility/override-changes-visibility',
});
JsiiDiagnostic.JSII_5003_OVERRIDE_CHANGES_RETURN_TYPE = Code.error({
    code: 5003,
    formatter: (newElement, action, newValue, oldValue) => `"${newElement}" changes the return type to "${newValue}" when ${action}. Change it to "${oldValue}"`,
    name: 'language-compatibility/override-changes-return-type',
});
JsiiDiagnostic.JSII_5004_OVERRIDE_CHANGES_PROP_TYPE = Code.error({
    code: 5004,
    formatter: (newElement, action, newType, oldType) => `"${newElement}" changes the property type to "${spec.describeTypeReference(newType)}" when ${action}. Change it to "${spec.describeTypeReference(oldType)}"`,
    name: 'language-compatibility/override-changes-property-type',
});
JsiiDiagnostic.JSII_5005_OVERRIDE_CHANGES_PARAM_COUNT = Code.error({
    code: 5005,
    formatter: (newElement, action, newCount, oldCount) => `"${newElement}" has ${newCount} parameters when ${action}. It should accept ${oldCount} parameters`,
    name: 'language-compatibility/override-changes-param-count',
});
JsiiDiagnostic.JSII_5006_OVERRIDE_CHANGES_PARAM_TYPE = Code.error({
    code: 5006,
    formatter: (newElement, action, newParam, oldParam) => `"${newElement}" changes the type of parameter "${newParam.name}" to ${spec.describeTypeReference(newParam.type)} when ${action}. Change it to ${spec.describeTypeReference(oldParam.type)}`,
    name: 'language-compatibility/override-changes-param-type',
});
JsiiDiagnostic.JSII_5007_OVERRIDE_CHANGES_VARIADIC = Code.error({
    code: 5007,
    formatter: (newElement, action, newVariadic = false, oldVariadic = false) => `"${newElement}" turns ${newVariadic ? 'variadic' : 'non variadic'} when ${action}. Make it ${oldVariadic ? 'variadic' : 'non-variadic'}`,
    name: 'language-compatibility/override-changes-variadic',
});
JsiiDiagnostic.JSII_5008_OVERRIDE_CHANGES_PARAM_OPTIONAL = Code.error({
    code: 5008,
    formatter: (newElement, action, newParam, oldParam) => `"${newElement}" turns parameter "${newParam.name}" ${newParam.optional ? 'optional' : 'required'} when ${action}. Make it ${oldParam.optional ? 'optional' : 'required'}`,
    name: 'language-compatibility/override-changes-param-optional',
});
JsiiDiagnostic.JSII_5009_OVERRIDE_CHANGES_PROP_OPTIONAL = Code.error({
    code: 5009,
    formatter: (newElement, action, newOptional = false, oldOptional = false) => `"${newElement}" turns ${newOptional ? 'optional' : 'required'} when ${action}. Make it ${oldOptional ? 'optional' : 'required'}`,
    name: 'language-compatibility/override-changes-prop-optional',
});
JsiiDiagnostic.JSII_5010_OVERRIDE_CHANGES_MUTABILITY = Code.error({
    code: 5010,
    formatter: (newElement, action, newReadonly = false, oldReadonly = false) => `"${newElement}" turns ${newReadonly ? 'readonly' : 'mutable'} when ${action}. Make it ${oldReadonly ? 'readonly' : 'mutable'}`,
    name: 'language-compatibility/override-changes-mutability',
});
JsiiDiagnostic.JSII_5011_SUBMODULE_NAME_CONFLICT = Code.error({
    code: 5011,
    formatter: (submoduleName, typeName, reserved) => `Submodule "${submoduleName}" conflicts with "${typeName}, as different languages could represent it as: ${reserved
        .map((x) => `"${x}"`)
        .join(', ')}"`,
    name: 'language-compatibility/submodule-name-conflicts',
});
JsiiDiagnostic.JSII_5012_NAMESPACE_IN_TYPE = Code.error({
    code: 5012,
    formatter: (typeName, namespaceName) => `All entities nested under a type (e.g: "${typeName}") must be concrete types, but "${namespaceName}" is a namespace. This structure cannot be supported in all languages (e.g: Java)`,
    name: 'language-compatibility/namespace-in-type',
});
JsiiDiagnostic.JSII_5013_STATIC_INSTANCE_CONFLICT = Code.error({
    code: 5013,
    formatter: (member, type) => `Member "${member}" of class "${type.fqn}" has both a static and an instance delcaration`,
    name: 'language-compatibility/static-instance-conflict',
});
JsiiDiagnostic.JSII_5014_INHERITED_STATIC_CONFLICT = Code.error({
    code: 5014,
    formatter: (member, type, baseMember, baseType) => `${member.static ? 'Static' : 'Instance'} member "${member.name}" of class "${type.fqn}" conflicts with ${baseMember.static ? 'static' : 'instance'} member in ancestor "${baseType.fqn}"`,
    name: 'language-compatibility/inherited-static-conflict',
});
JsiiDiagnostic.JSII_5015_REDECLARED_INTERFACE_MEMBER = Code.error({
    code: 5015,
    formatter: (memberName, iface) => `Interface "${iface.fqn}" re-declares member "${memberName}". This is not supported as it results in invalid C#.`,
    name: 'language-compatibility/redeclared-interface-member',
});
JsiiDiagnostic.JSII_5016_PROHIBITED_MEMBER_NAME = Code.error({
    code: 5016,
    formatter: (badName) => `Members cannot be named "${badName}" as it conflicts with synthetic declarations in some languages.`,
    name: 'language-compatibility/prohibited-member-name',
});
JsiiDiagnostic.JSII_5017_POSITIONAL_KEYWORD_CONFLICT = Code.error({
    code: 5017,
    formatter: (badName) => `Parameter name "${badName}" is also the name of a property in a struct parameter. Rename the positional parameter.`,
    name: 'language-compatibility/positional-keyword-conflict',
});
JsiiDiagnostic.JSII_5018_RESERVED_WORD = Code.warning({
    code: 5018,
    formatter: (badName, languages) => `"${badName}" is a reserved word in ${languages.join(', ')}. Using this name may cause problems when generating language bindings. Consider a different name.`,
    name: 'language-compatibility/reserved-word',
});
JsiiDiagnostic.JSII_5019_MEMBER_TYPE_NAME_CONFLICT = Code.warning({
    code: 5019,
    formatter: (memberKind, memberSymbol, declaringType) => `The ${memberKind} name "${memberSymbol.name}" conflicts with the declaring ${declaringType.kind} "${declaringType.name}". This will result in renaming the ${declaringType.kind} to "_${declaringType.name}" in C#. Consider renaming "${memberSymbol.name}".`,
    name: 'language-compatibility/member-name-conflicts-with-type-name',
});
JsiiDiagnostic.JSII_5020_STATIC_MEMBER_CONFLICTS_WITH_NESTED_TYPE = Code.error({
    code: 5020,
    formatter: (nestingType, staticMember, nestedType) => `The static member "${nestingType.name}.${staticMember.name}" has the same PascalCased representation as nested type "${nestingType.name}.${nestedType.name}". This would result in invalid code in Go.`,
    name: 'language-compatibility/static-member-name-conflicts-with-nested-type',
});
JsiiDiagnostic.JSII_5021_ABSTRACT_CLASS_MISSING_PROP_IMPL = Code.error({
    code: 5021,
    formatter: (intf, cls, prop) => `A declaration of "${intf.name}.${prop}" is missing on class "${cls.name}". Declare the property as "public abstract" if you want to defer it to subclasses.`,
    name: 'language-compatibility/abstract-class-missing-prop-impl',
});
//////////////////////////////////////////////////////////////////////////////
// 6000 => 6999 -- RESERVED
//////////////////////////////////////////////////////////////////////////////
// 7000 => 7999 -- DOCUMENTATION ERRORS
JsiiDiagnostic.JSII_7000_NON_EXISTENT_PARAMETER = Code.warning({
    code: 7000,
    formatter: (method, param) => `Documentation for method "${method.name}" refers to non-existent @param "${param}"`,
    name: 'documentation/non-existent-parameter',
});
JsiiDiagnostic.JSII_7001_ILLEGAL_HINT = Code.error({
    code: 7001,
    formatter: (hint, ...valid) => `Illegal use of "@${hint}" hint. It is only valid on ${valid.join(', ')}.`,
    name: 'documentation/illegal-hint',
});
JsiiDiagnostic.JSII_7999_DOCUMENTATION_ERROR = Code.error({
    code: 7999,
    formatter: (messageText) => messageText,
    name: 'documentation/documentation-error',
});
//////////////////////////////////////////////////////////////////////////////
// 8000 => 8999 -- JSII STYLE ENFORCEMENT
JsiiDiagnostic.JSII_8000_PASCAL_CASED_TYPE_NAMES = Code.error({
    code: 8000,
    formatter: (badName, expectedName = (0, case_1.pascal)(badName)) => `Type names must be PascalCased. Rename "${badName}" to "${expectedName}"`,
    name: 'code-style/type-names-must-use-pascal-case',
});
JsiiDiagnostic.JSII_8001_ALL_CAPS_ENUM_MEMBERS = Code.error({
    code: 8001,
    formatter: (badName, typeName) => `Enum members must be ALL_CAPS. Rename "${typeName}.${badName}" to "${(0, case_1.constant)(badName)}"`,
    name: 'code-style/enum-members-must-use-all-caps',
});
JsiiDiagnostic.JSII_8002_CAMEL_CASED_MEMBERS = Code.error({
    code: 8002,
    formatter: (badName, typeName) => `Method and property (unless they are static readonly) names must use camelCase. Rename "${typeName}.${badName}" to "${(0, case_1.camel)(badName)}"`,
    name: 'code-style/member-names-must-use-camel-case',
});
JsiiDiagnostic.JSII_8003_STATIC_CONST_CASING = Code.error({
    code: 8003,
    formatter: (badName, typeName) => `Static constant names must use ALL_CAPS, PascalCase, or camelCase. Rename "${typeName}.${badName}" to "${(0, case_1.constant)(badName)}"`,
    name: 'code-style/static-readonly-property-casing',
});
JsiiDiagnostic.JSII_8004_SUBMOULE_NAME_CASING = Code.error({
    code: 8004,
    formatter: (badName) => `Submodule namespaces must be camelCased or snake_cased. Rename "${badName}" to ${(0, case_1.camel)(badName)}`,
    name: 'code-style/submodule-name-casing',
});
JsiiDiagnostic.JSII_8005_INTERNAL_UNDERSCORE = Code.error({
    code: 8005,
    formatter: (badName) => `Members marked with @internal must have a name starting with "_". Rename "${badName}" to "_${badName}"`,
    name: 'code-style/internal-members-underscore-prefix',
});
JsiiDiagnostic.JSII_8006_UNDERSCORE_INTERNAL = Code.error({
    code: 8006,
    formatter: (badName) => `Members with a name starting with "_" (e.g: "${badName}") must be marked @internal`,
    name: 'code-style/underscored-members-must-be-internal',
});
JsiiDiagnostic.JSII_8007_BEHAVIORAL_INTERFACE_NAME = Code.error({
    code: 8007,
    formatter: (badName) => `Interface contains behavior. Rename "${badName}" to "I${badName}"`,
    name: 'code-style/behavioral-interface-name',
});
//////////////////////////////////////////////////////////////////////////////
// 9000 => 9999 -- SURPRISING ERRORS & INFORMATIONAL MESSAGES
JsiiDiagnostic.JSII_9000_UNKNOWN_MODULE = Code.error({
    code: 9000,
    formatter: (moduleName) => `Encountered use of module that is not declared in "dependencies" or "peerDependencies": "${moduleName}"`,
    name: 'miscellaneous/unknown-module',
});
JsiiDiagnostic.JSII_9001_TYPE_NOT_FOUND = Code.error({
    code: 9001,
    formatter: (typeRef) => `Type not found in the corresponding assembly: "${typeRef.fqn}"`,
    name: 'miscellaneous/type-not-found',
});
JsiiDiagnostic.JSII_9002_UNRESOLVEABLE_TYPE = Code.error({
    code: 9002,
    formatter: (reference) => `Type "${reference}" is part of the public API but not exported (@internal or not exported from the package.json "main" file). Either export it or add @internal explicitly if you want this to be a hidden base class.`,
    name: 'miscellaneous/unresolveable-type',
});
JsiiDiagnostic.JSII_9003_UNRESOLVEABLE_MODULE = Code.error({
    code: 9003,
    formatter: (location) => `Unable to resolve module location "${location}"`,
    name: 'miscellaneous/unresolveable-module',
});
JsiiDiagnostic.JSII_9004_UNABLE_TO_COMPUTE_SIGNATURE = Code.error({
    code: 9004,
    formatter: (methodName, type) => `Unable to compute signature for method "${methodName}" of "${type.fqn}"`,
    name: 'miscellaneous/unable-to-compute-signature',
});
JsiiDiagnostic.JSII_9996_UNNECESSARY_TOKEN = Code.message({
    code: 9996,
    formatter: () => 'Unnecessary token, consider removing it',
    name: 'miscellaneous/unnecessary-token',
});
JsiiDiagnostic.JSII_9997_UNKNOWN_ERROR = Code.error({
    code: 9997,
    formatter: (error) => `Unknown error: ${error.message} -- ${error.stack}`,
    name: 'miscellaneous/unknown-error',
});
JsiiDiagnostic.JSII_9998_UNSUPPORTED_NODE = Code.message({
    code: 9998,
    formatter: (kindOrMessage) => typeof kindOrMessage === 'string'
        ? kindOrMessage
        : `Unsupported ${ts.SyntaxKind[kindOrMessage]} node. This declaration will not be accessible from other languages.`,
    name: 'miscellaneous/unsupported-node',
});
//////////////////////////////////////////////////////////////////////////////
JsiiDiagnostic.JSII_9999_RELATED_INFO = Code.suggestion({
    code: 9999,
    formatter: (messageText) => messageText,
    name: 'miscellaneous/related-info',
});
//////////////////////////////////////////////////////////////////////////////
/**
 * This symbol unequivocally identifies the `JsiiDiagnostic` domain.
 */
JsiiDiagnostic.DOMAIN = Symbol('jsii');
function configureCategories(records) {
    for (const [code, category] of Object.entries(records)) {
        const diagCode = Code.lookup(diagnosticCode(code));
        if (!diagCode) {
            throw new Error(`Unrecognized diagnostic code '${code}'`);
        }
        diagCode.category = category;
    }
}
function diagnosticCode(str) {
    if (str.toLowerCase().startsWith('jsii')) {
        const re = /^JSII(\d+)$/i.exec(str);
        if (re) {
            return parseInt(re[1], 10);
        }
        throw new Error(`Invalid diagnostic code ${str}. A number must follow code that starts with 'JSII'`);
    }
    return str;
}
//# sourceMappingURL=jsii-diagnostic.js.map