import { SnippetLocation } from '../snippet';
/**
 * Tablet file schema
 */
export interface TabletSchema {
    /**
     * Schema version
     */
    version: string;
    /**
     * What version of the tool this schema was generated with
     *
     * Hashing algorithms may depend on the tool version, and the tool
     * will reject tablets generated by different versions.
     *
     * Since tablets are designed to be used as scratch space during a build, not
     * designed to be stored long-term, this limitation does not impact
     * usability.
     */
    toolVersion: string;
    /**
     * All the snippets in the tablet
     */
    snippets: {
        [key: string]: TranslatedSnippetSchema;
    };
}
export declare const ORIGINAL_SNIPPET_KEY = "$";
/**
 * Schema for a snippet
 */
export interface TranslatedSnippetSchema {
    /**
     * Translations for each individual language
     *
     * Since TypeScript is a valid output translation, the original will be
     * listed under the key '$'.
     */
    readonly translations: {
        [key: string]: TranslationSchema;
    };
    /**
     * A description of the location this code snippet was found
     */
    readonly location: SnippetLocation;
    /**
     * Whether this was compiled without errors
     *
     * Undefined means compilation was not attempted.
     */
    readonly didCompile?: boolean;
    /**
     * FQNs of classes and functions referenced in this snippet.
     */
    readonly fqnsReferenced?: string[];
    /**
     * A fingerprint of the types referenced in `fqnsReferenced`.
     *
     * This can be used to validate/invalidate previous compilations of a snippet.
     *
     * A snippet needs to be recompiled if:
     *
     * - Its source text changes: hash will be different
     * - Its fixture changes: fullSource will be different
     * - The referenced types have changed: fingerprint will be different
     */
    readonly fqnsFingerprint?: string;
    /**
     * Counts the number of instances each kind of Typescript object shows up in the snippet AST.
     */
    readonly syntaxKindCounter?: {
        [key: string]: number;
    };
    /**
     * The full source (with fixture) that was compiled
     */
    readonly fullSource?: string;
}
/**
 * A single snippet's translation
 */
export interface TranslationSchema {
    /**
     * The source of a single translation
     */
    readonly source: string;
    /**
     * The version of the translator used to obtain this translation
     */
    readonly version: string;
}
//# sourceMappingURL=schema.d.ts.map