import * as ts from 'typescript';
import { TargetLanguage } from './target-language';
import { OTree } from '../o-tree';
import { AstRenderer, AstHandler, CommentSyntax } from '../renderer';
import { ImportStatement } from '../typescript/imports';
export declare class VisualizeAstVisitor implements AstHandler<void> {
    private readonly includeHandlerNames?;
    readonly language = TargetLanguage.PYTHON;
    readonly defaultContext: void;
    constructor(includeHandlerNames?: boolean | undefined);
    mergeContext(_old: any, _update: any): any;
    commentRange(node: CommentSyntax, _context: AstRenderer<void>): OTree;
    jsDoc(_node: ts.JSDoc, _context: AstRenderer<void>): OTree;
    sourceFile(node: ts.SourceFile, context: AstRenderer<void>): OTree;
    importStatement(node: ImportStatement, context: AstRenderer<void>): OTree;
    functionDeclaration(node: ts.FunctionDeclaration, children: AstRenderer<void>): OTree;
    stringLiteral(node: ts.StringLiteral | ts.NoSubstitutionTemplateLiteral, children: AstRenderer<void>): OTree;
    numericLiteral(node: ts.NumericLiteral, children: AstRenderer<void>): OTree;
    identifier(node: ts.Identifier, children: AstRenderer<void>): OTree;
    block(node: ts.Block, children: AstRenderer<void>): OTree;
    parameterDeclaration(node: ts.ParameterDeclaration, children: AstRenderer<void>): OTree;
    returnStatement(node: ts.ReturnStatement, children: AstRenderer<void>): OTree;
    binaryExpression(node: ts.BinaryExpression, children: AstRenderer<void>): OTree;
    ifStatement(node: ts.IfStatement, context: AstRenderer<void>): OTree;
    propertyAccessExpression(node: ts.PropertyAccessExpression, context: AstRenderer<void>): OTree;
    callExpression(node: ts.CallExpression, context: AstRenderer<void>): OTree;
    expressionStatement(node: ts.ExpressionStatement, context: AstRenderer<void>): OTree;
    token<A extends ts.SyntaxKind>(node: ts.Token<A>, context: AstRenderer<void>): OTree;
    objectLiteralExpression(node: ts.ObjectLiteralExpression, context: AstRenderer<void>): OTree;
    newExpression(node: ts.NewExpression, context: AstRenderer<void>): OTree;
    awaitExpression(node: ts.AwaitExpression, context: AstRenderer<void>): OTree;
    propertyAssignment(node: ts.PropertyAssignment, context: AstRenderer<void>): OTree;
    variableStatement(node: ts.VariableStatement, context: AstRenderer<void>): OTree;
    variableDeclarationList(node: ts.VariableDeclarationList, context: AstRenderer<void>): OTree;
    variableDeclaration(node: ts.VariableDeclaration, context: AstRenderer<void>): OTree;
    arrayLiteralExpression(node: ts.ArrayLiteralExpression, context: AstRenderer<void>): OTree;
    shorthandPropertyAssignment(node: ts.ShorthandPropertyAssignment, context: AstRenderer<void>): OTree;
    forOfStatement(node: ts.ForOfStatement, context: AstRenderer<void>): OTree;
    classDeclaration(node: ts.ClassDeclaration, context: AstRenderer<void>): OTree;
    constructorDeclaration(node: ts.ConstructorDeclaration, context: AstRenderer<void>): OTree;
    propertyDeclaration(node: ts.PropertyDeclaration, context: AstRenderer<void>): OTree;
    computedPropertyName(node: ts.Expression, context: AstRenderer<void>): OTree;
    methodDeclaration(node: ts.MethodDeclaration, context: AstRenderer<void>): OTree;
    interfaceDeclaration(node: ts.InterfaceDeclaration, context: AstRenderer<void>): OTree;
    propertySignature(node: ts.PropertySignature, context: AstRenderer<void>): OTree;
    methodSignature(node: ts.MethodSignature, context: AstRenderer<void>): OTree;
    asExpression(node: ts.AsExpression, context: AstRenderer<void>): OTree;
    prefixUnaryExpression(node: ts.PrefixUnaryExpression, context: AstRenderer<void>): OTree;
    spreadElement(node: ts.SpreadElement, context: AstRenderer<void>): OTree;
    spreadAssignment(node: ts.SpreadAssignment, context: AstRenderer<void>): OTree;
    ellipsis(node: ts.SpreadAssignment | ts.SpreadElement, context: AstRenderer<void>): OTree;
    templateExpression(node: ts.TemplateExpression, context: AstRenderer<void>): OTree;
    elementAccessExpression(node: ts.ElementAccessExpression, context: AstRenderer<void>): OTree;
    nonNullExpression(node: ts.NonNullExpression, context: AstRenderer<void>): OTree;
    parenthesizedExpression(node: ts.ParenthesizedExpression, context: AstRenderer<void>): OTree;
    maskingVoidExpression(node: ts.VoidExpression, context: AstRenderer<void>): OTree;
    private defaultNode;
}
//# sourceMappingURL=visualize.d.ts.map