"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeReference = void 0;
const jsii = require("@jsii/spec");
class TypeReference {
    constructor(system, spec) {
        this.system = system;
        this.spec = spec;
    }
    toString() {
        if (this.void) {
            return 'void';
        }
        if (this.primitive) {
            return this.primitive;
        }
        if (this.fqn) {
            return this.fqn;
        }
        if (this.arrayOfType) {
            return `Array<${this.arrayOfType.toString()}>`;
        }
        if (this.mapOfType) {
            return `Map<string => ${this.mapOfType.toString()}>`;
        }
        if (this.unionOfTypes) {
            const union = this.unionOfTypes.map((x) => x.toString());
            union.sort();
            return union.join(' | ');
        }
        throw new Error('Invalid type reference');
    }
    get void() {
        return !this.spec;
    }
    get isAny() {
        return this.primitive === 'any';
    }
    get primitive() {
        if (!jsii.isPrimitiveTypeReference(this.spec)) {
            return undefined;
        }
        return this.spec.primitive;
    }
    get fqn() {
        return jsii.isNamedTypeReference(this.spec) ? this.spec.fqn : undefined;
    }
    get type() {
        if (!jsii.isNamedTypeReference(this.spec)) {
            return undefined;
        }
        return this.system.findFqn(this.spec.fqn);
    }
    get arrayOfType() {
        if (!jsii.isCollectionTypeReference(this.spec)) {
            return undefined;
        }
        if (this.spec.collection.kind !== jsii.CollectionKind.Array) {
            return undefined;
        }
        return new TypeReference(this.system, this.spec.collection.elementtype);
    }
    get mapOfType() {
        if (!jsii.isCollectionTypeReference(this.spec)) {
            return undefined;
        }
        if (this.spec.collection.kind !== jsii.CollectionKind.Map) {
            return undefined;
        }
        return new TypeReference(this.system, this.spec.collection.elementtype);
    }
    get unionOfTypes() {
        if (!jsii.isUnionTypeReference(this.spec)) {
            return undefined;
        }
        return this.spec.union.types.map((t) => new TypeReference(this.system, t));
    }
}
exports.TypeReference = TypeReference;
//# sourceMappingURL=type-ref.js.map