"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cleanup = exports.render = void 0;
const events_1 = require("events");
const ink_1 = require("ink");
class Stdout extends events_1.EventEmitter {
    constructor() {
        super(...arguments);
        this.frames = [];
        this.write = (frame) => {
            this.frames.push(frame);
            this._lastFrame = frame;
        };
        this.lastFrame = () => {
            return this._lastFrame;
        };
    }
    get columns() {
        return 100;
    }
}
class Stderr extends events_1.EventEmitter {
    constructor() {
        super(...arguments);
        this.frames = [];
        this.write = (frame) => {
            this.frames.push(frame);
            this._lastFrame = frame;
        };
        this.lastFrame = () => {
            return this._lastFrame;
        };
    }
}
class Stdin extends events_1.EventEmitter {
    constructor() {
        super(...arguments);
        this.isTTY = true;
        this.write = (data) => {
            this.emit('data', data);
        };
    }
    setEncoding() {
        // Do nothing
    }
    setRawMode() {
        // Do nothing
    }
    resume() {
        // Do nothing
    }
    pause() {
        // Do nothing
    }
}
const instances = [];
exports.render = (tree) => {
    const stdout = new Stdout();
    const stderr = new Stderr();
    const stdin = new Stdin();
    const instance = ink_1.render(tree, {
        stdout: stdout,
        stderr: stderr,
        stdin: stdin,
        debug: true,
        exitOnCtrlC: false,
        patchConsole: false
    });
    instances.push(instance);
    return {
        rerender: instance.rerender,
        unmount: instance.unmount,
        cleanup: instance.cleanup,
        stdout,
        stderr,
        stdin,
        frames: stdout.frames,
        lastFrame: stdout.lastFrame
    };
};
exports.cleanup = () => {
    for (const instance of instances) {
        instance.unmount();
        instance.cleanup();
    }
};
//# sourceMappingURL=index.js.map