/// <reference types="node" />
import { EventEmitter } from 'events';
import type { ReactElement } from 'react';
declare class Stdout extends EventEmitter {
    get columns(): number;
    readonly frames: string[];
    private _lastFrame?;
    write: (frame: string) => void;
    lastFrame: () => string | undefined;
}
declare class Stderr extends EventEmitter {
    readonly frames: string[];
    private _lastFrame?;
    write: (frame: string) => void;
    lastFrame: () => string | undefined;
}
declare class Stdin extends EventEmitter {
    isTTY: boolean;
    write: (data: string) => void;
    setEncoding(): void;
    setRawMode(): void;
    resume(): void;
    pause(): void;
}
interface Instance {
    rerender: (tree: ReactElement) => void;
    unmount: () => void;
    cleanup: () => void;
    stdout: Stdout;
    stderr: Stderr;
    stdin: Stdin;
    frames: string[];
    lastFrame: () => string | undefined;
}
export declare const render: (tree: ReactElement) => Instance;
export declare const cleanup: () => void;
export {};
