"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValidateTerraformVersion = void 0;
const util_1 = require("../util");
const validate_binary_version_1 = require("./validate-binary-version");
/**
 * Validates the existence of a Terraform binary and with a certain version or higher.
 */
class ValidateTerraformVersion extends validate_binary_version_1.ValidateBinaryVersion {
    constructor(versionConstraint, hint) {
        super(util_1.terraformBinaryName, versionConstraint, `${util_1.terraformBinaryName} version`, hint);
        this.versionConstraint = versionConstraint;
        this.hint = hint;
    }
}
exports.ValidateTerraformVersion = ValidateTerraformVersion;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdGUtdGVycmFmb3JtLXZlcnNpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ2YWxpZGF0ZS10ZXJyYWZvcm0tdmVyc2lvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7OztHQUdHOzs7QUFFSCxrQ0FBOEM7QUFDOUMsdUVBQWtFO0FBRWxFOztHQUVHO0FBQ0gsTUFBYSx3QkFBeUIsU0FBUSwrQ0FBcUI7SUFDakUsWUFDWSxpQkFBeUIsRUFDekIsSUFBYTtRQUV2QixLQUFLLENBQ0gsMEJBQW1CLEVBQ25CLGlCQUFpQixFQUNqQixHQUFHLDBCQUFtQixVQUFVLEVBQ2hDLElBQUksQ0FDTCxDQUFDO1FBUlEsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFRO1FBQ3pCLFNBQUksR0FBSixJQUFJLENBQVM7SUFRekIsQ0FBQztDQUNGO0FBWkQsNERBWUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmMuXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuICovXG5cbmltcG9ydCB7IHRlcnJhZm9ybUJpbmFyeU5hbWUgfSBmcm9tIFwiLi4vdXRpbFwiO1xuaW1wb3J0IHsgVmFsaWRhdGVCaW5hcnlWZXJzaW9uIH0gZnJvbSBcIi4vdmFsaWRhdGUtYmluYXJ5LXZlcnNpb25cIjtcblxuLyoqXG4gKiBWYWxpZGF0ZXMgdGhlIGV4aXN0ZW5jZSBvZiBhIFRlcnJhZm9ybSBiaW5hcnkgYW5kIHdpdGggYSBjZXJ0YWluIHZlcnNpb24gb3IgaGlnaGVyLlxuICovXG5leHBvcnQgY2xhc3MgVmFsaWRhdGVUZXJyYWZvcm1WZXJzaW9uIGV4dGVuZHMgVmFsaWRhdGVCaW5hcnlWZXJzaW9uIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHZlcnNpb25Db25zdHJhaW50OiBzdHJpbmcsXG4gICAgcHJvdGVjdGVkIGhpbnQ/OiBzdHJpbmcsXG4gICkge1xuICAgIHN1cGVyKFxuICAgICAgdGVycmFmb3JtQmluYXJ5TmFtZSxcbiAgICAgIHZlcnNpb25Db25zdHJhaW50LFxuICAgICAgYCR7dGVycmFmb3JtQmluYXJ5TmFtZX0gdmVyc2lvbmAsXG4gICAgICBoaW50LFxuICAgICk7XG4gIH1cbn1cbiJdfQ==