import { IValidation } from "constructs";
/**
 * A validation that can be applied to a construct that will error if the
 * construct is being used in an environment with a version of a binary lower than the specified version.
 */
export declare class ValidateBinaryVersion implements IValidation {
    protected binary: string;
    protected versionConstraint: string;
    protected versionCommand: string;
    protected hint?: string | undefined;
    constructor(binary: string, versionConstraint: string, versionCommand: string, hint?: string | undefined);
    validate(): string[];
}
