"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateEnvironment = validateEnvironment;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const constructs_1 = require("constructs");
const errors_1 = require("./errors");
/**
 * fails early if the environment contains e.g. invalid version combinations
 */
function validateEnvironment() {
    validateConstructsIsV10();
}
/**
 * fails early if the environment contains e.g. invalid version combinations
 * for constructs
 */
function validateConstructsIsV10() {
    const construct = new constructs_1.Construct(null, "test");
    // construct.node was added in v10
    if (typeof construct.node === "undefined") {
        throw (0, errors_1.constructDependencyBelowV10)();
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdGVFbnZpcm9ubWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInZhbGlkYXRlRW52aXJvbm1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFRQSxrREFFQztBQVZELCtCQUErQjtBQUMvQixtQ0FBbUM7QUFDbkMsMkNBQXVDO0FBQ3ZDLHFDQUF1RDtBQUV2RDs7R0FFRztBQUNILFNBQWdCLG1CQUFtQjtJQUNqQyx1QkFBdUIsRUFBRSxDQUFDO0FBQzVCLENBQUM7QUFFRDs7O0dBR0c7QUFDSCxTQUFTLHVCQUF1QjtJQUM5QixNQUFNLFNBQVMsR0FBRyxJQUFJLHNCQUFTLENBQUMsSUFBVyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0lBQ3JELGtDQUFrQztJQUNsQyxJQUFJLE9BQU8sU0FBUyxDQUFDLElBQUksS0FBSyxXQUFXLEVBQUUsQ0FBQztRQUMxQyxNQUFNLElBQUEsb0NBQTJCLEdBQUUsQ0FBQztJQUN0QyxDQUFDO0FBQ0gsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmNcbi8vIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBNUEwtMi4wXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuaW1wb3J0IHsgY29uc3RydWN0RGVwZW5kZW5jeUJlbG93VjEwIH0gZnJvbSBcIi4vZXJyb3JzXCI7XG5cbi8qKlxuICogZmFpbHMgZWFybHkgaWYgdGhlIGVudmlyb25tZW50IGNvbnRhaW5zIGUuZy4gaW52YWxpZCB2ZXJzaW9uIGNvbWJpbmF0aW9uc1xuICovXG5leHBvcnQgZnVuY3Rpb24gdmFsaWRhdGVFbnZpcm9ubWVudCgpIHtcbiAgdmFsaWRhdGVDb25zdHJ1Y3RzSXNWMTAoKTtcbn1cblxuLyoqXG4gKiBmYWlscyBlYXJseSBpZiB0aGUgZW52aXJvbm1lbnQgY29udGFpbnMgZS5nLiBpbnZhbGlkIHZlcnNpb24gY29tYmluYXRpb25zXG4gKiBmb3IgY29uc3RydWN0c1xuICovXG5mdW5jdGlvbiB2YWxpZGF0ZUNvbnN0cnVjdHNJc1YxMCgpIHtcbiAgY29uc3QgY29uc3RydWN0ID0gbmV3IENvbnN0cnVjdChudWxsIGFzIGFueSwgXCJ0ZXN0XCIpO1xuICAvLyBjb25zdHJ1Y3Qubm9kZSB3YXMgYWRkZWQgaW4gdjEwXG4gIGlmICh0eXBlb2YgY29uc3RydWN0Lm5vZGUgPT09IFwidW5kZWZpbmVkXCIpIHtcbiAgICB0aHJvdyBjb25zdHJ1Y3REZXBlbmRlbmN5QmVsb3dWMTAoKTtcbiAgfVxufVxuIl19