export declare const terraformBinaryName: string;
/**
 * Merges `source` into `target`, overriding any existing values.
 * `undefined` will cause a value to be deleted.
 */
export declare function deepMerge(target: any, ...sources: any[]): any;
/**
 * Transforms a string to snake case
 */
export declare function snakeCase(str: string): string;
/**
 * Transforms all keys in a object to snake case
 */
export declare function keysToSnakeCase(object: any): any;
/**
 * dynamic attributes are located at a different position than normal block attributes
 * This method detects them and moves them from .attributeName to .dynamic.attributeName
 * It also invokes the .toTerraform() method on the dynamic attribute to get the correct
 * Terraform representation
 */
export declare function processDynamicAttributesForHcl(attributes: {
    [name: string]: any;
}): {
    [name: string]: any;
};
/**
 * dynamic attributes are located at a different position than normal block attributes
 * This method detects them and moves them from .attributeName to .dynamic.attributeName
 * It also invokes the .toTerraform() method on the dynamic attribute to get the correct
 * Terraform representation
 */
export declare function processDynamicAttributes(attributes: {
    [name: string]: any;
}): {
    [name: string]: any;
};
