"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultTokenResolver = exports.StringConcat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const encoding_1 = require("./private/encoding");
const token_map_1 = require("./private/token-map");
const errors_1 = require("../errors");
/**
 * Converts all fragments to strings and concats those
 *
 * Drops 'undefined's.
 */
class StringConcat {
    /**
     * Concatenates string fragments
     */
    join(left, right) {
        if (left === undefined) {
            return right !== undefined ? `${right}` : undefined;
        }
        if (right === undefined) {
            return `${left}`;
        }
        return `${left}${right}`;
    }
}
exports.StringConcat = StringConcat;
_a = JSII_RTTI_SYMBOL_1;
StringConcat[_a] = { fqn: "cdktf.StringConcat", version: "0.21.0" };
/**
 * Default resolver implementation
 *
 * @experimental
 */
class DefaultTokenResolver {
    /**
     * Resolves tokens
     */
    constructor(concat) {
        this.concat = concat;
    }
    /**
     * Default Token resolution
     *
     * Resolve the Token, recurse into whatever it returns,
     * then finally post-process it.
     */
    resolveToken(t, context, postProcessor) {
        try {
            let resolved = t.resolve(context);
            // The token might have returned more values that need resolving, recurse
            resolved = context.resolve(resolved);
            resolved = postProcessor.postProcess(resolved, context);
            return resolved;
        }
        catch (e) {
            const err = e;
            let message = `Resolution error: ${err.message}.`;
            if (t.creationStack && t.creationStack.length > 0) {
                message += `\nObject creation stack:\n  at ${t.creationStack.join("\n  at ")}`;
            }
            err.message = message;
            throw err;
        }
    }
    /**
     * Resolve string fragments to Tokens
     */
    resolveString(fragments, context) {
        return fragments.mapTokens(context).join(this.concat);
    }
    /**
     * Resolves a list of string
     */
    resolveList(xs, context) {
        // Must be a singleton list token, because concatenation is not allowed.
        if (xs.length !== 1) {
            throw (0, errors_1.stringValueAddedToReferenceList)(xs);
        }
        const str = encoding_1.TokenString.forListToken(xs[0]);
        const tokenMap = token_map_1.TokenMap.instance();
        const fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
        if (fragments.length !== 1) {
            throw (0, errors_1.cannotConcatenateStringsInTokenizedStringArray)(xs[0]);
        }
        return fragments.mapTokens(context).firstValue;
    }
    /**
     * Resolves a list of numbers
     */
    resolveNumberList(xs, context) {
        // Must be a singleton list token, because concatenation is not allowed.
        if (xs.length !== 1) {
            throw (0, errors_1.numberValueAddedToReferenceList)(xs);
        }
        const token = token_map_1.TokenMap.instance().lookupNumberList(xs);
        if (token === undefined) {
            return xs;
        }
        return context.resolve(token);
    }
    /**
     * Resolves a map token
     */
    resolveMap(xs, context) {
        const keys = Object.keys(xs);
        if (keys.length !== 1) {
            throw (0, errors_1.mapValueAddedToReferenceList)(JSON.stringify(xs));
        }
        const str = encoding_1.TokenString.forMapToken(keys[0]);
        const tokenMap = token_map_1.TokenMap.instance();
        const fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
        if (fragments.length !== 1) {
            throw (0, errors_1.cannotConcatenateStringsInTokenizedMap)(xs[0]);
        }
        return fragments.mapTokens(context).firstValue;
    }
}
exports.DefaultTokenResolver = DefaultTokenResolver;
_b = JSII_RTTI_SYMBOL_1;
DefaultTokenResolver[_b] = { fqn: "cdktf.DefaultTokenResolver", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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