"use strict";
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
// copied from https://github.com/aws/constructs/blob/e01e47f78ef1e9b600efcd23ff7705aa8d384017/lib/private/stack-trace.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.captureStackTrace = captureStackTrace;
/**
 * Captures a complete stack trace at the point of invocation.
 */
// eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
function captureStackTrace(below) {
    below = below || captureStackTrace; // hide myself if nothing else
    const object = { stack: "" };
    const previousLimit = Error.stackTraceLimit;
    try {
        Error.stackTraceLimit = Number.MAX_SAFE_INTEGER;
        Error.captureStackTrace(object, below);
    }
    finally {
        Error.stackTraceLimit = previousLimit;
    }
    if (!object.stack) {
        return [];
    }
    return object.stack
        .split("\n")
        .slice(1)
        .map((s) => s.replace(/^\s*at\s+/, ""));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhY2stdHJhY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFjay10cmFjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsK0JBQStCO0FBQy9CLG1DQUFtQztBQUNuQyx5SEFBeUg7O0FBTXpILDhDQWlCQztBQXJCRDs7R0FFRztBQUNILHNFQUFzRTtBQUN0RSxTQUFnQixpQkFBaUIsQ0FBQyxLQUFnQjtJQUNoRCxLQUFLLEdBQUcsS0FBSyxJQUFJLGlCQUFpQixDQUFDLENBQUMsOEJBQThCO0lBQ2xFLE1BQU0sTUFBTSxHQUFHLEVBQUUsS0FBSyxFQUFFLEVBQUUsRUFBRSxDQUFDO0lBQzdCLE1BQU0sYUFBYSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7SUFDNUMsSUFBSSxDQUFDO1FBQ0gsS0FBSyxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDaEQsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxLQUFLLENBQUMsQ0FBQztJQUN6QyxDQUFDO1lBQVMsQ0FBQztRQUNULEtBQUssQ0FBQyxlQUFlLEdBQUcsYUFBYSxDQUFDO0lBQ3hDLENBQUM7SUFDRCxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ2xCLE9BQU8sRUFBRSxDQUFDO0lBQ1osQ0FBQztJQUNELE9BQU8sTUFBTSxDQUFDLEtBQUs7U0FDaEIsS0FBSyxDQUFDLElBQUksQ0FBQztTQUNYLEtBQUssQ0FBQyxDQUFDLENBQUM7U0FDUixHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7QUFDNUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmNcbi8vIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBNUEwtMi4wXG4vLyBjb3BpZWQgZnJvbSBodHRwczovL2dpdGh1Yi5jb20vYXdzL2NvbnN0cnVjdHMvYmxvYi9lMDFlNDdmNzhlZjFlOWI2MDBlZmNkMjNmZjc3MDVhYThkMzg0MDE3L2xpYi9wcml2YXRlL3N0YWNrLXRyYWNlLnRzXG5cbi8qKlxuICogQ2FwdHVyZXMgYSBjb21wbGV0ZSBzdGFjayB0cmFjZSBhdCB0aGUgcG9pbnQgb2YgaW52b2NhdGlvbi5cbiAqL1xuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIEB0eXBlc2NyaXB0LWVzbGludC9uby11bnNhZmUtZnVuY3Rpb24tdHlwZVxuZXhwb3J0IGZ1bmN0aW9uIGNhcHR1cmVTdGFja1RyYWNlKGJlbG93PzogRnVuY3Rpb24pOiBzdHJpbmdbXSB7XG4gIGJlbG93ID0gYmVsb3cgfHwgY2FwdHVyZVN0YWNrVHJhY2U7IC8vIGhpZGUgbXlzZWxmIGlmIG5vdGhpbmcgZWxzZVxuICBjb25zdCBvYmplY3QgPSB7IHN0YWNrOiBcIlwiIH07XG4gIGNvbnN0IHByZXZpb3VzTGltaXQgPSBFcnJvci5zdGFja1RyYWNlTGltaXQ7XG4gIHRyeSB7XG4gICAgRXJyb3Iuc3RhY2tUcmFjZUxpbWl0ID0gTnVtYmVyLk1BWF9TQUZFX0lOVEVHRVI7XG4gICAgRXJyb3IuY2FwdHVyZVN0YWNrVHJhY2Uob2JqZWN0LCBiZWxvdyk7XG4gIH0gZmluYWxseSB7XG4gICAgRXJyb3Iuc3RhY2tUcmFjZUxpbWl0ID0gcHJldmlvdXNMaW1pdDtcbiAgfVxuICBpZiAoIW9iamVjdC5zdGFjaykge1xuICAgIHJldHVybiBbXTtcbiAgfVxuICByZXR1cm4gb2JqZWN0LnN0YWNrXG4gICAgLnNwbGl0KFwiXFxuXCIpXG4gICAgLnNsaWNlKDEpXG4gICAgLm1hcCgocykgPT4gcy5yZXBsYWNlKC9eXFxzKmF0XFxzKy8sIFwiXCIpKTtcbn1cbiJdfQ==