"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LazyBase = exports.Lazy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
// Copied from https://github.com/aws/constructs/blob/e01e47f78ef1e9b600efcd23ff7705aa8d384017/lib/lazy.ts
const stack_trace_1 = require("./private/stack-trace");
const token_1 = require("./token");
/**
 * Lazily produce a value
 *
 * Can be used to return a string, list or numeric value whose actual value
 * will only be calculated later, during synthesis.
 */
class Lazy {
    /**
     * Returns a stringified token for a lazy value.
     * @param producer The producer
     * @param options Options
     */
    static stringValue(producer, options = {}) {
        return token_1.Token.asString(new LazyString(producer), options);
    }
    /**
     * Returns a numberified token for a lazy value.
     * @param producer The producer
     */
    static numberValue(producer) {
        return token_1.Token.asNumber(new LazyNumber(producer));
    }
    /**
     * Returns a list-ified token for a lazy value.
     * @param producer The producer
     * @param options Options
     */
    static listValue(producer, options = {}) {
        return token_1.Token.asList(new LazyList(producer, options), options);
    }
    /**
     * Produces a lazy token from an untyped value.
     * @param producer The lazy producer
     * @param options Options
     */
    static anyValue(producer, options = {}) {
        return new LazyAny(producer, options);
    }
}
exports.Lazy = Lazy;
_a = JSII_RTTI_SYMBOL_1;
Lazy[_a] = { fqn: "cdktf.Lazy", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class LazyBase {
    constructor() {
        this.postProcessors = [];
        this.creationStack = (0, stack_trace_1.captureStackTrace)();
    }
    resolve(context) {
        return this.postProcessors.reduce((val, pp) => pp.postProcess(val, context), this.resolveLazy(context));
    }
    toString() {
        return token_1.Token.asString(this);
    }
    // will be invoked when this Lazy's resolve() method is called
    addPostProcessor(postProcessor) {
        this.postProcessors.push(postProcessor);
    }
    /**
     * Turn this Token into JSON
     *
     * Called automatically when JSON.stringify() is called on a Token.
     */
    toJSON() {
        return "<unresolved-lazy>";
    }
}
exports.LazyBase = LazyBase;
_b = JSII_RTTI_SYMBOL_1;
LazyBase[_b] = { fqn: "cdktf.LazyBase", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class LazyString extends LazyBase {
    constructor(producer) {
        super();
        this.producer = producer;
    }
    resolveLazy(context) {
        return this.producer.produce(context);
    }
}
// eslint-disable-next-line jsdoc/require-jsdoc
class LazyNumber extends LazyBase {
    constructor(producer) {
        super();
        this.producer = producer;
    }
    resolveLazy(context) {
        return this.producer.produce(context);
    }
}
// eslint-disable-next-line jsdoc/require-jsdoc
class LazyList extends LazyBase {
    constructor(producer, options = {}) {
        super();
        this.producer = producer;
        this.options = options;
    }
    resolveLazy(context) {
        const ret = this.producer.produce(context);
        if (ret !== undefined && ret.length === 0 && this.options.omitEmpty) {
            return undefined;
        }
        return ret;
    }
}
// eslint-disable-next-line jsdoc/require-jsdoc
class LazyAny extends LazyBase {
    constructor(producer, options = {}) {
        super();
        this.producer = producer;
        this.options = options;
    }
    resolveLazy(context) {
        const ret = this.producer.produce(context);
        if (Array.isArray(ret) && ret.length === 0 && this.options.omitEmptyArray) {
            return undefined;
        }
        return ret;
    }
}
//# sourceMappingURL=data:application/json;base64,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