"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupJest = setupJest;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const errors_1 = require("../../errors");
const matchers_1 = require("../matchers");
const matchers_2 = require("../matchers");
// Jest supports asymetric matchers (https://github.com/facebook/jest/blob/main/packages/expect/src/asymmetricMatchers.ts)
// These matchers are great in expressing partial equality in a deeply nested way
// As we want to support more than one testing framework we can not use them everywhere
function jestPassEvaluation(items, assertedProperties) {
    if (Object.entries(assertedProperties).length === 0) {
        return items.length > 0;
    }
    else {
        if (global.expect) {
            const expect = global.expect;
            return expect
                .arrayContaining([expect.objectContaining(assertedProperties)])
                .asymmetricMatch(items);
        }
        else {
            throw (0, errors_1.jestNotInstantiated)();
        }
    }
}
function setupJest() {
    if (!("expect" in global)) {
        throw (0, errors_1.expectNotGloballyAccessible)();
    }
    const expect = global.expect;
    expect.extend({
        toHaveResource(received, resourceConstructor) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_2.getToHaveResourceWithProperties)(jestPassEvaluation)(received, resourceConstructor, {}));
        },
        toHaveResourceWithProperties(received, resourceConstructor, properties) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_2.getToHaveResourceWithProperties)(jestPassEvaluation)(received, resourceConstructor, properties));
        },
        toHaveDataSource(received, dataSourceConstructor) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_1.getToHaveDataSourceWithProperties)(jestPassEvaluation)(received, dataSourceConstructor, {}));
        },
        toHaveDataSourceWithProperties(received, dataSourceConstructor, properties) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_1.getToHaveDataSourceWithProperties)(jestPassEvaluation)(received, dataSourceConstructor, properties));
        },
        toHaveProvider(received, providerConstructor) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_2.getToHaveProviderWithProperties)(jestPassEvaluation)(received, providerConstructor, {}));
        },
        toHaveProviderWithProperties(received, providerConstructor, properties) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_2.getToHaveProviderWithProperties)(jestPassEvaluation)(received, providerConstructor, properties));
        },
        toBeValidTerraform(received) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_1.toBeValidTerraform)(received));
        },
        toPlanSuccessfully(received) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_1.toPlanSuccessfully)(received));
        },
    });
}
//# sourceMappingURL=data:application/json;base64,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