"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const jest_1 = require("../jest");
const index_1 = require("../../index");
const data_source_1 = require("../../../../test/helper/data-source");
const resource_1 = require("../../../../test/helper/resource");
describe("jest-adapter", () => {
    beforeAll(() => {
        (0, jest_1.setupJest)();
    });
    it("should add extra matchers", () => {
        expect(expect(true).toHaveResource).toBeDefined();
        expect(expect(true).toHaveResourceWithProperties).toBeDefined();
    });
    describe("jestPassEvaluation", () => {
        it("fails with jest error message", () => {
            expect(() => expect(index_1.Testing.synthScope((stack) => {
                new data_source_1.TestDataSource(stack, "test-data-source", {
                    name: "foo",
                });
                new resource_1.TestResource(stack, "test-resource", {
                    name: "bar",
                });
            })).toHaveResourceWithProperties(resource_1.TestResource, {
                name: "bazs",
                foo: expect.arrayContaining([expect.anything()]),
            })).toThrowErrorMatchingInlineSnapshot(`
        "Expected test_resource with properties {"name":"bazs","foo":"expect.ArrayContaining"} to be present in synthesized stack.
        Found 1 test_resource resources instead:
        [
          {
            "name": "bar"
          }
        ]"
      `);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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